/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.utils;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.PrePersist;
import com.google.code.morphia.annotations.Transient;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;

public abstract class LongIdEntity {
    @Id
    protected Long myLongId;
    @Transient
    protected final Datastore ds;

    protected LongIdEntity(Datastore ds) {
        this.ds = ds;
    }

    @PrePersist
    void prePersist() {
        if (this.myLongId == null) {
            UpdateOperations<StoredId> uOps;
            String collName = this.ds.getCollection(this.getClass()).getName();
            Query<StoredId> q = this.ds.find(StoredId.class, "_id", collName);
            StoredId newId = this.ds.findAndModify(q, uOps = this.ds.createUpdateOperations(StoredId.class).inc("value"));
            if (newId == null) {
                newId = new StoredId(collName);
                this.ds.save(newId);
            }
            this.myLongId = newId.getValue();
        }
    }

    @Entity(value="ids", noClassnameStored=true)
    public static class StoredId {
        @Id
        final String className;
        protected Long value = 1L;

        public StoredId(String name) {
            this.className = name;
        }

        protected StoredId() {
            this.className = "";
        }

        public Long getValue() {
            return this.value;
        }
    }
}

