/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.lazy.proxy;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Key;
import com.google.code.morphia.mapping.lazy.DatastoreProvider;
import com.google.code.morphia.mapping.lazy.proxy.AbstractReference;
import com.google.code.morphia.mapping.lazy.proxy.ProxiedEntityReferenceMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableMapObjectReference
extends AbstractReference
implements ProxiedEntityReferenceMap {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, Key<?>> keyMap;

    public SerializableMapObjectReference(Map mapToProxy, Class referenceObjClass, boolean ignoreMissing, DatastoreProvider p) {
        super(p, referenceObjClass, ignoreMissing);
        this.object = mapToProxy;
        this.keyMap = new LinkedHashMap();
    }

    public void __put(String key, Key k) {
        this.keyMap.put(key, k);
    }

    @Override
    protected Object fetch() {
        Map m = (Map)this.object;
        m.clear();
        for (Map.Entry<String, Key<?>> e : this.keyMap.entrySet()) {
            Key<?> entityKey = e.getValue();
            Object entity = this.fetch(entityKey);
            m.put(e.getKey(), entity);
        }
        return m;
    }

    @Override
    protected void beforeWriteObject() {
        if (!this.__isFetched()) {
            return;
        }
        this.syncKeys();
        ((Map)this.object).clear();
    }

    private void syncKeys() {
        Datastore ds = this.p.get();
        this.keyMap.clear();
        Map map = (Map)this.object;
        for (Map.Entry e : map.entrySet()) {
            this.keyMap.put((String)e.getKey(), ds.getKey(e.getValue()));
        }
    }

    @Override
    public Map<String, Key<?>> __getReferenceMap() {
        return this.keyMap;
    }
}

