/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.lazy.proxy;

import com.google.code.morphia.mapping.lazy.proxy.ProxiedReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHelper {
    public static <T> T unwrap(T entity) {
        if (ProxyHelper.isProxy(entity)) {
            return (T)ProxyHelper.asProxy(entity).__unwrap();
        }
        return entity;
    }

    private static <T> ProxiedReference asProxy(T entity) {
        return (ProxiedReference)entity;
    }

    public static boolean isProxy(Object entity) {
        return entity != null && ProxyHelper.isProxied(entity.getClass());
    }

    public static boolean isProxied(Class<?> clazz) {
        return ProxiedReference.class.isAssignableFrom(clazz);
    }

    public static Class getReferentClass(Object entity) {
        if (ProxyHelper.isProxy(entity)) {
            return ProxyHelper.asProxy(entity).__getReferenceObjClass();
        }
        return entity != null ? entity.getClass() : null;
    }

    public static boolean isFetched(Object entity) {
        if (entity == null) {
            return true;
        }
        if (!ProxyHelper.isProxy(entity)) {
            return true;
        }
        return ProxyHelper.asProxy(entity).__isFetched();
    }

    public static boolean isUnFetched(Object entity) {
        return !ProxyHelper.isFetched(entity);
    }
}

