/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping;

import com.google.code.morphia.DatastoreImpl;
import com.google.code.morphia.Key;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.CustomMapper;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.mapping.cache.EntityCache;
import com.google.code.morphia.mapping.lazy.LazyFeatureDependencies;
import com.google.code.morphia.mapping.lazy.proxy.ProxiedEntityReference;
import com.google.code.morphia.mapping.lazy.proxy.ProxiedEntityReferenceList;
import com.google.code.morphia.mapping.lazy.proxy.ProxiedEntityReferenceMap;
import com.google.code.morphia.mapping.lazy.proxy.ProxyHelper;
import com.google.code.morphia.utils.ReflectionUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceMapper
implements CustomMapper {
    public static final Logr log = MorphiaLoggerFactory.get(ReferenceMapper.class);

    ReferenceMapper() {
    }

    @Override
    public void toDBObject(Object entity, MappedField mf, BasicDBObject dbObject, Map<Object, DBObject> involvedObjects, Mapper mapr) {
        String name = mf.getNameToStore();
        Object fieldValue = mf.getFieldValue(entity);
        if (fieldValue == null && !mapr.getOptions().storeNulls) {
            return;
        }
        if (mf.isMap()) {
            this.writeMap(mf, dbObject, name, fieldValue, mapr);
        } else if (mf.isMultipleValues()) {
            this.writeCollection(mf, dbObject, name, fieldValue, mapr);
        } else {
            this.writeSingle(dbObject, name, fieldValue, mapr);
        }
    }

    private void writeSingle(BasicDBObject dbObject, String name, Object fieldValue, Mapper mapr) {
        DBRef dbrefFromKey = mapr.keyToRef(this.getKey(fieldValue, mapr));
        dbObject.put(name, (Object)dbrefFromKey);
    }

    private void writeCollection(MappedField mf, BasicDBObject dbObject, String name, Object fieldValue, Mapper mapr) {
        if (fieldValue != null) {
            ArrayList<DBRef> values = new ArrayList<DBRef>();
            if (ProxyHelper.isProxy(fieldValue) && ProxyHelper.isUnFetched(fieldValue)) {
                ProxiedEntityReferenceList p = (ProxiedEntityReferenceList)fieldValue;
                List<Key<?>> getKeysAsList = p.__getKeysAsList();
                for (Key<?> key : getKeysAsList) {
                    values.add(mapr.keyToRef(key));
                }
            } else if (mf.getType().isArray()) {
                for (Object o : (Object[])fieldValue) {
                    values.add(mapr.keyToRef(this.getKey(o, mapr)));
                }
            } else {
                for (Object o : (Iterable)fieldValue) {
                    values.add(mapr.keyToRef(this.getKey(o, mapr)));
                }
            }
            if (values.size() > 0 || mapr.getOptions().storeEmpties) {
                dbObject.put(name, values);
            }
        }
    }

    private void writeMap(MappedField mf, BasicDBObject dbObject, String name, Object fieldValue, Mapper mapr) {
        Map map = (Map)fieldValue;
        if (map != null) {
            Map values = mapr.getOptions().objectFactory.createMap(mf);
            if (ProxyHelper.isProxy(map) && ProxyHelper.isUnFetched(map)) {
                ProxiedEntityReferenceMap proxy = (ProxiedEntityReferenceMap)((Object)map);
                Map<String, Key<?>> refMap = proxy.__getReferenceMap();
                for (Map.Entry<String, Key<?>> entry : refMap.entrySet()) {
                    String strKey = entry.getKey();
                    values.put(strKey, mapr.keyToRef(entry.getValue()));
                }
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    String strKey = mapr.converters.encode(entry.getKey()).toString();
                    values.put(strKey, mapr.keyToRef(this.getKey(entry.getValue(), mapr)));
                }
            }
            if (values.size() > 0 || mapr.getOptions().storeEmpties) {
                dbObject.put(name, (Object)values);
            }
        }
    }

    private Key<?> getKey(Object entity, Mapper mapr) {
        try {
            if (entity instanceof ProxiedEntityReference) {
                ProxiedEntityReference proxy = (ProxiedEntityReference)entity;
                return proxy.__getKey();
            }
            MappedClass mappedClass = mapr.getMappedClass(entity);
            Object id = mappedClass.getIdField().get(entity);
            if (id == null) {
                throw new MappingException("@Id field cannot be null!");
            }
            Key key = new Key(mappedClass.getCollectionName(), id);
            return key;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    @Deprecated
    void fromDBObject(DBObject dbObject, MappedField mf, Object entity, Mapper mapr) {
        this.fromDBObject(dbObject, mf, entity, mapr.createEntityCache(), mapr);
    }

    @Override
    public void fromDBObject(DBObject dbObject, MappedField mf, Object entity, EntityCache cache, Mapper mapr) {
        Class fieldType = mf.getType();
        Reference refAnn = mf.getAnnotation(Reference.class);
        if (mf.isMap()) {
            this.readMap(dbObject, mf, entity, refAnn, cache, mapr);
        } else if (mf.isMultipleValues()) {
            this.readCollection(dbObject, mf, entity, refAnn, cache, mapr);
        } else {
            this.readSingle(dbObject, mf, entity, fieldType, refAnn, cache, mapr);
        }
    }

    private void readSingle(DBObject dbObject, MappedField mf, Object entity, Class fieldType, Reference refAnn, EntityCache cache, Mapper mapr) {
        Class referenceObjClass = fieldType;
        DBRef dbRef = (DBRef)mf.getDbObjectValue(dbObject);
        if (dbRef != null) {
            Object resolvedObject = null;
            if (refAnn.lazy() && LazyFeatureDependencies.assertDependencyFullFilled()) {
                if (this.exists(referenceObjClass, dbRef, cache, mapr)) {
                    resolvedObject = this.createOrReuseProxy(referenceObjClass, dbRef, cache, mapr);
                } else if (!refAnn.ignoreMissing()) {
                    throw new MappingException("The reference(" + dbRef.toString() + ") could not be fetched for " + mf.getFullName());
                }
            } else {
                resolvedObject = this.resolveObject(dbRef, mf, cache, mapr);
            }
            mf.setFieldValue(entity, resolvedObject);
        }
    }

    private void readCollection(DBObject dbObject, MappedField mf, Object entity, Reference refAnn, EntityCache cache, Mapper mapr) {
        Collection<Object> references;
        Class referenceObjClass = mf.getSubClass();
        Collection collection = references = mf.isSet() ? mapr.getOptions().objectFactory.createSet(mf) : mapr.getOptions().objectFactory.createList(mf);
        if (refAnn.lazy() && LazyFeatureDependencies.assertDependencyFullFilled()) {
            Object dbVal = mf.getDbObjectValue(dbObject);
            if (dbVal != null) {
                references = mapr.proxyFactory.createListProxy(references, referenceObjClass, refAnn.ignoreMissing(), mapr.datastoreProvider);
                ProxiedEntityReferenceList referencesAsProxy = (ProxiedEntityReferenceList)((Object)references);
                if (dbVal instanceof List) {
                    List refList = (List)dbVal;
                    DatastoreImpl dsi = (DatastoreImpl)mapr.datastoreProvider.get();
                    List keys = dsi.getKeysByRefs(refList);
                    if (keys.size() != refList.size()) {
                        String msg = "Some of the references could not be fetched for " + mf.getFullName() + ". " + refList + " != " + keys;
                        if (!refAnn.ignoreMissing()) {
                            throw new MappingException(msg);
                        }
                        log.warning(msg);
                    }
                    referencesAsProxy.__addAll(keys);
                } else {
                    DBRef dbRef = (DBRef)dbVal;
                    if (!this.exists(mf.getSubClass(), dbRef, cache, mapr)) {
                        String msg = "The reference(" + dbRef.toString() + ") could not be fetched for " + mf.getFullName();
                        if (!refAnn.ignoreMissing()) {
                            throw new MappingException(msg);
                        }
                        log.warning(msg);
                    } else {
                        referencesAsProxy.__add(mapr.refToKey(dbRef));
                    }
                }
            }
        } else {
            Object dbVal = mf.getDbObjectValue(dbObject);
            if (dbVal != null) {
                if (dbVal instanceof List) {
                    List refList = (List)dbVal;
                    for (Object dbRefObj : refList) {
                        DBRef dbRef = (DBRef)dbRefObj;
                        Object ent = this.resolveObject(dbRef, mf, cache, mapr);
                        if (ent == null) continue;
                        references.add(ent);
                    }
                } else {
                    DBRef dbRef = (DBRef)dbVal;
                    Object ent = this.resolveObject(dbRef, mf, cache, mapr);
                    if (ent != null) {
                        references.add(ent);
                    }
                }
            }
        }
        if (mf.getType().isArray()) {
            mf.setFieldValue(entity, ReflectionUtils.convertToArray(mf.getSubClass(), ReflectionUtils.iterToList(references)));
        } else {
            mf.setFieldValue(entity, references);
        }
    }

    boolean exists(Class c, DBRef dbRef, EntityCache cache, Mapper mapr) {
        Key key = mapr.refToKey(dbRef);
        Boolean cached = cache.exists(key);
        if (cached != null) {
            return cached;
        }
        DatastoreImpl dsi = (DatastoreImpl)mapr.datastoreProvider.get();
        DBCollection dbColl = dsi.getCollection(c);
        if (!dbColl.getName().equals(dbRef.getRef())) {
            log.warning("Class " + c.getName() + " is stored in the '" + dbColl.getName() + "' collection but a reference was found for this type to another collection, '" + dbRef.getRef() + "'. The reference will be loaded using the class anyway. " + dbRef);
        }
        boolean exists = dsi.find(dbRef.getRef(), c).disableValidation().filter("_id", dbRef.getId()).asKeyList().size() == 1;
        cache.notifyExists(key, exists);
        return exists;
    }

    Object resolveObject(DBRef dbRef, MappedField mf, EntityCache cache, Mapper mapr) {
        boolean ignoreMissing;
        Key key = mapr.createKey(mf.isSingleValue() ? mf.getType() : mf.getSubClass(), dbRef.getId());
        Object cached = cache.getEntity(key);
        if (cached != null) {
            return cached;
        }
        BasicDBObject refDbObject = (BasicDBObject)dbRef.fetch();
        if (refDbObject != null) {
            Object refObj = mapr.getOptions().objectFactory.createInstance(mapr, mf, (DBObject)refDbObject);
            refObj = mapr.fromDb((DBObject)refDbObject, refObj, cache);
            cache.putEntity(key, refObj);
            return refObj;
        }
        boolean bl = ignoreMissing = mf.getAnnotation(Reference.class) != null && mf.getAnnotation(Reference.class).ignoreMissing();
        if (!ignoreMissing) {
            throw new MappingException("The reference(" + dbRef.toString() + ") could not be fetched for " + mf.getFullName());
        }
        return null;
    }

    private void readMap(DBObject dbObject, MappedField mf, Object entity, Reference refAnn, EntityCache cache, Mapper mapr) {
        Class referenceObjClass = mf.getSubClass();
        Map map = mapr.getOptions().objectFactory.createMap(mf);
        BasicDBObject dbVal = (BasicDBObject)mf.getDbObjectValue(dbObject);
        if (dbVal != null) {
            if (refAnn.lazy() && LazyFeatureDependencies.assertDependencyFullFilled()) {
                map = mapr.proxyFactory.createMapProxy(map, referenceObjClass, refAnn.ignoreMissing(), mapr.datastoreProvider);
            }
            for (Map.Entry entry : dbVal.entrySet()) {
                DBRef dbRef = (DBRef)entry.getValue();
                if (refAnn.lazy() && LazyFeatureDependencies.assertDependencyFullFilled()) {
                    ProxiedEntityReferenceMap proxiedMap = (ProxiedEntityReferenceMap)((Object)map);
                    proxiedMap.__put((String)entry.getKey(), mapr.refToKey(dbRef));
                    continue;
                }
                Object resolvedObject = this.resolveObject(dbRef, mf, cache, mapr);
                map.put(entry.getKey(), resolvedObject);
            }
        }
        mf.setFieldValue(entity, map);
    }

    private Object createOrReuseProxy(Class referenceObjClass, DBRef dbRef, EntityCache cache, Mapper mapr) {
        Key key = mapr.refToKey(dbRef);
        Object proxyAlreadyCreated = cache.getProxy(key);
        if (proxyAlreadyCreated != null) {
            return proxyAlreadyCreated;
        }
        Object newProxy = mapr.proxyFactory.createProxy(referenceObjClass, key, mapr.datastoreProvider);
        cache.putProxy(key, newProxy);
        return newProxy;
    }
}

