/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping;

import com.google.code.morphia.EntityInterceptor;
import com.google.code.morphia.Key;
import com.google.code.morphia.annotations.Converters;
import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.NotSaved;
import com.google.code.morphia.annotations.PostLoad;
import com.google.code.morphia.annotations.PreLoad;
import com.google.code.morphia.annotations.PrePersist;
import com.google.code.morphia.annotations.PreSave;
import com.google.code.morphia.annotations.Property;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Serialized;
import com.google.code.morphia.converters.DefaultConverters;
import com.google.code.morphia.converters.TypeConverter;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.EmbeddedMapper;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.MapperOptions;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.mapping.Serializer;
import com.google.code.morphia.mapping.cache.DefaultEntityCache;
import com.google.code.morphia.mapping.cache.EntityCache;
import com.google.code.morphia.mapping.lazy.DatastoreProvider;
import com.google.code.morphia.mapping.lazy.DefaultDatastoreProvider;
import com.google.code.morphia.mapping.lazy.LazyFeatureDependencies;
import com.google.code.morphia.mapping.lazy.LazyProxyFactory;
import com.google.code.morphia.mapping.lazy.proxy.ProxiedEntityReference;
import com.google.code.morphia.mapping.lazy.proxy.ProxyHelper;
import com.google.code.morphia.query.FilterOperator;
import com.google.code.morphia.query.ValidationException;
import com.google.code.morphia.utils.ReflectionUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bson.BSONEncoder;
import org.bson.BSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper {
    private static final Logr log = MorphiaLoggerFactory.get(Mapper.class);
    public static final String ID_KEY = "_id";
    public static final String IGNORED_FIELDNAME = ".";
    public static final String CLASS_NAME_FIELDNAME = "className";
    private final Map<String, MappedClass> mappedClasses = new ConcurrentHashMap<String, MappedClass>();
    private final Map<String, Set<MappedClass>> mappedClassesByCollection = new ConcurrentHashMap<String, Set<MappedClass>>();
    private final List<EntityInterceptor> interceptors = new LinkedList<EntityInterceptor>();
    final Map<Class, Object> instanceCache = new ConcurrentHashMap<Class, Object>();
    private MapperOptions opts = new MapperOptions();
    LazyProxyFactory proxyFactory = LazyFeatureDependencies.createDefaultProxyFactory();
    DatastoreProvider datastoreProvider = new DefaultDatastoreProvider();
    DefaultConverters converters = new DefaultConverters();

    public Mapper() {
        this.converters.setMapper(this);
    }

    public Mapper(MapperOptions opts) {
        this();
        this.opts = opts;
    }

    public void addInterceptor(EntityInterceptor ei) {
        this.interceptors.add(ei);
    }

    public Collection<EntityInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public MapperOptions getOptions() {
        return this.opts;
    }

    public void setOptions(MapperOptions options) {
        this.opts = options;
    }

    public boolean isMapped(Class c) {
        return this.mappedClasses.containsKey(c.getName());
    }

    public MappedClass addMappedClass(Class c) {
        MappedClass mc = new MappedClass(c, this);
        return this.addMappedClass(mc, true);
    }

    public MappedClass addMappedClass(MappedClass mc) {
        return this.addMappedClass(mc, true);
    }

    private MappedClass addMappedClass(MappedClass mc, boolean validate) {
        Converters c;
        if (validate) {
            mc.validate();
        }
        if ((c = (Converters)mc.getAnnotation(Converters.class)) != null) {
            for (Class<? extends TypeConverter> clazz : c.value()) {
                if (this.converters.isRegistered(clazz)) continue;
                this.converters.addConverter(clazz);
            }
        }
        this.mappedClasses.put(mc.getClazz().getName(), mc);
        Set<MappedClass> mcs = this.mappedClassesByCollection.get(mc.getCollectionName());
        if (mcs == null) {
            mcs = new HashSet<MappedClass>();
        }
        mcs.add(mc);
        return mc;
    }

    public Collection<MappedClass> getMappedClasses() {
        return new ArrayList<MappedClass>(this.mappedClasses.values());
    }

    public Map<String, MappedClass> getMCMap() {
        return Collections.unmodifiableMap(this.mappedClasses);
    }

    public MappedClass getMappedClass(Object obj) {
        MappedClass mc;
        Class type;
        if (obj == null) {
            return null;
        }
        Class clazz = type = obj instanceof Class ? (Class)obj : obj.getClass();
        if (ProxyHelper.isProxy(obj)) {
            type = ProxyHelper.getReferentClass(obj);
        }
        if ((mc = this.mappedClasses.get(type.getName())) == null) {
            mc = new MappedClass(type, this);
            this.addMappedClass(mc, false);
        }
        return mc;
    }

    public String getCollectionName(Object object) {
        MappedClass mc = this.getMappedClass(object);
        return mc.getCollectionName();
    }

    public void updateKeyInfo(Object entity, DBObject dbObj, EntityCache cache) {
        MappedClass mc = this.getMappedClass(entity);
        if (mc.getIdField() != null && dbObj != null && dbObj.get(ID_KEY) != null) {
            try {
                MappedField mf = mc.getMappedIdField();
                Object oldIdValue = mc.getIdField().get(entity);
                this.readMappedField(dbObj, mf, entity, cache);
                Object dbIdValue = mc.getIdField().get(entity);
                if (oldIdValue != null) {
                    if (!dbIdValue.equals(oldIdValue)) {
                        mf.setFieldValue(entity, oldIdValue);
                        throw new RuntimeException("@Id mismatch: " + oldIdValue + " != " + dbIdValue + " for " + entity.getClass().getName());
                    }
                } else {
                    mc.getIdField().set(entity, dbIdValue);
                }
            }
            catch (Exception e) {
                if (e.getClass().equals(RuntimeException.class)) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Error setting @Id field after save/insert.", e);
            }
        }
    }

    public Object fromDBObject(Class entityClass, DBObject dbObject, EntityCache cache) {
        if (dbObject == null) {
            Throwable t = new Throwable();
            log.error("Somebody passed in a null dbObject; bad client!", t);
            return null;
        }
        Object entity = null;
        entity = this.opts.objectFactory.createInstance(entityClass, dbObject);
        entity = this.fromDb(dbObject, entity, cache);
        return entity;
    }

    Object toMongoObject(Object javaObj, boolean includeClassName) {
        if (javaObj == null) {
            return null;
        }
        Class<?> origClass = javaObj.getClass();
        Object newObj = this.converters.encode(origClass, javaObj);
        if (newObj == null) {
            log.warning("converted " + javaObj + " to null");
            return newObj;
        }
        Class<?> type = newObj.getClass();
        boolean bSameType = origClass.equals(type);
        if (!(bSameType || Map.class.isAssignableFrom(type) || Iterable.class.isAssignableFrom(type))) {
            return newObj;
        }
        boolean isSingleValue = true;
        boolean isMap = false;
        Class subType = null;
        if (type.isArray() || Map.class.isAssignableFrom(type) || Iterable.class.isAssignableFrom(type)) {
            isSingleValue = false;
            isMap = ReflectionUtils.implementsInterface(type, Map.class);
            Class clazz = type.isArray() ? type.getComponentType() : (subType = ReflectionUtils.getParameterizedClass(type, isMap ? 1 : 0));
        }
        if (isSingleValue && !ReflectionUtils.isPropertyType(type)) {
            DBObject dbObj = this.toDBObject(newObj);
            if (!includeClassName) {
                dbObj.removeField(CLASS_NAME_FIELDNAME);
            }
            return dbObj;
        }
        if (newObj instanceof DBObject) {
            return newObj;
        }
        if (isMap) {
            if (ReflectionUtils.isPropertyType(subType)) {
                return this.toDBObject(newObj);
            }
            HashMap m = new HashMap();
            for (Map.Entry entry : ((Map)newObj).entrySet()) {
                m.put(entry.getKey(), this.toMongoObject(entry.getValue(), includeClassName));
            }
            return m;
        }
        if (!isSingleValue && !ReflectionUtils.isPropertyType(subType)) {
            ArrayList<Object> vals = new ArrayList<Object>();
            if (type.isArray()) {
                for (Object obj : (Object[])newObj) {
                    vals.add(this.toMongoObject(obj, includeClassName));
                }
            } else {
                for (Object t : (Iterable)newObj) {
                    vals.add(this.toMongoObject(t, includeClassName));
                }
            }
            return vals;
        }
        return newObj;
    }

    public Object toMongoObject(MappedField mf, MappedClass mc, Object value) {
        Object mappedValue = value;
        if (mf != null && (mf.hasAnnotation(Reference.class) || mf.getType().isAssignableFrom(Key.class) || mf.getType().isAssignableFrom(DBRef.class)) || mc != null && mc.getEntityAnnotation() != null) {
            try {
                Key<Object> k = value instanceof Key ? (Key<Object>)value : this.getKey(value);
                mappedValue = this.keyToRef(k);
            }
            catch (Exception e) {
                log.debug("Error converting value(" + value + ") to reference.", e);
                mappedValue = this.toMongoObject(value, false);
            }
        } else if (mf != null && mf.hasAnnotation(Serialized.class)) {
            try {
                mappedValue = Serializer.serialize(value, !mf.getAnnotation(Serialized.class).disableCompression());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (value instanceof DBObject) {
            mappedValue = value;
        } else if ((mappedValue = this.toMongoObject(value, EmbeddedMapper.shouldSaveClassName(value, mappedValue, mf))) instanceof DBObject && !EmbeddedMapper.shouldSaveClassName(value, mappedValue, mf)) {
            ((DBObject)mappedValue).removeField(CLASS_NAME_FIELDNAME);
        }
        return mappedValue;
    }

    public Object getId(Object entity) {
        entity = ProxyHelper.unwrap(entity);
        MappedClass mc = this.getMappedClass(entity.getClass());
        try {
            return mc.getIdField().get(entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> Key<T> getKey(T entity) {
        if (entity instanceof ProxiedEntityReference) {
            ProxiedEntityReference proxy = (ProxiedEntityReference)entity;
            return proxy.__getKey();
        }
        if ((entity = ProxyHelper.unwrap(entity)) instanceof Key) {
            return (Key)entity;
        }
        Object id = this.getId(entity);
        if (id == null) {
            throw new MappingException("Could not get id for " + entity.getClass().getName());
        }
        return new Key(entity.getClass(), id);
    }

    public DBObject toDBObject(Object entity) {
        return this.toDBObject(entity, null);
    }

    public DBObject toDBObject(Object entity, Map<Object, DBObject> involvedObjects) {
        return this.toDBObject(entity, involvedObjects, true);
    }

    DBObject toDBObject(Object entity, Map<Object, DBObject> involvedObjects, boolean lifecycle) {
        BasicDBObject dbObject = new BasicDBObject();
        MappedClass mc = this.getMappedClass(entity);
        if (mc.getEntityAnnotation() == null || !mc.getEntityAnnotation().noClassnameStored()) {
            dbObject.put(CLASS_NAME_FIELDNAME, (Object)entity.getClass().getName());
        }
        if (lifecycle) {
            dbObject = (BasicDBObject)mc.callLifecycleMethods(PrePersist.class, entity, (DBObject)dbObject, this);
        }
        for (MappedField mf : mc.getPersistenceFields()) {
            try {
                this.writeMappedField(dbObject, mf, entity, involvedObjects);
            }
            catch (Exception e) {
                throw new MappingException("Error mapping field:" + mf.getFullName(), e);
            }
        }
        if (involvedObjects != null) {
            involvedObjects.put(entity, (DBObject)dbObject);
        }
        if (lifecycle) {
            mc.callLifecycleMethods(PreSave.class, entity, (DBObject)dbObject, this);
        }
        return dbObject;
    }

    Object fromDb(DBObject dbObject, Object entity, EntityCache cache) {
        if (entity instanceof MappedField) {
            this.readMappedField(dbObject, (MappedField)entity, entity, cache);
            return entity;
        }
        if (dbObject.containsField(ID_KEY) && this.getMappedClass(entity).getIdField() != null && this.getMappedClass(entity).getEntityAnnotation() != null) {
            Key key = new Key(entity.getClass(), dbObject.get(ID_KEY));
            Object cachedInstance = cache.getEntity(key);
            if (cachedInstance != null) {
                return cachedInstance;
            }
            cache.putEntity(key, entity);
        }
        MappedClass mc = this.getMappedClass(entity);
        dbObject = (BasicDBObject)mc.callLifecycleMethods(PreLoad.class, entity, dbObject, this);
        try {
            for (MappedField mf : mc.getPersistenceFields()) {
                this.readMappedField(dbObject, mf, entity, cache);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (dbObject.containsField(ID_KEY) && this.getMappedClass(entity).getIdField() != null) {
            Key key = new Key(entity.getClass(), dbObject.get(ID_KEY));
            cache.putEntity(key, entity);
        }
        mc.callLifecycleMethods(PostLoad.class, entity, dbObject, this);
        return entity;
    }

    private void readMappedField(DBObject dbObject, MappedField mf, Object entity, EntityCache cache) {
        if (mf.hasAnnotation(Property.class) || mf.hasAnnotation(Serialized.class) || mf.isTypeMongoCompatible() || this.converters.hasSimpleValueConverter(mf)) {
            this.opts.valueMapper.fromDBObject(dbObject, mf, entity, cache, this);
        } else if (mf.hasAnnotation(Embedded.class)) {
            this.opts.embeddedMapper.fromDBObject(dbObject, mf, entity, cache, this);
        } else if (mf.hasAnnotation(Reference.class)) {
            this.opts.referenceMapper.fromDBObject(dbObject, mf, entity, cache, this);
        } else {
            this.opts.defaultMapper.fromDBObject(dbObject, mf, entity, cache, this);
        }
    }

    private void writeMappedField(BasicDBObject dbObject, MappedField mf, Object entity, Map<Object, DBObject> involvedObjects) {
        Class annType = null;
        if (mf.hasAnnotation(NotSaved.class)) {
            return;
        }
        for (Class testType : new Class[]{Property.class, Embedded.class, Serialized.class, Reference.class}) {
            if (!mf.hasAnnotation(testType)) continue;
            annType = testType;
            break;
        }
        if (Property.class.equals(annType) || Serialized.class.equals(annType) || mf.isTypeMongoCompatible() || this.converters.hasSimpleValueConverter(mf) || this.converters.hasSimpleValueConverter(mf.getFieldValue(entity))) {
            this.opts.valueMapper.toDBObject(entity, mf, dbObject, involvedObjects, this);
        } else if (Reference.class.equals((Object)annType)) {
            this.opts.referenceMapper.toDBObject(entity, mf, dbObject, involvedObjects, this);
        } else if (Embedded.class.equals((Object)annType)) {
            this.opts.embeddedMapper.toDBObject(entity, mf, dbObject, involvedObjects, this);
        } else {
            log.debug("No annotation was found, using default mapper " + this.opts.defaultMapper + " for " + mf);
            this.opts.defaultMapper.toDBObject(entity, mf, dbObject, involvedObjects, this);
        }
    }

    public DefaultConverters getConverters() {
        return this.converters;
    }

    public EntityCache createEntityCache() {
        return new DefaultEntityCache();
    }

    public <T> Key<T> refToKey(DBRef ref) {
        Key key = new Key(ref.getRef(), ref.getId());
        return key;
    }

    public DBRef keyToRef(Key key) {
        if (key.getKindClass() == null && key.getKind() == null) {
            throw new IllegalStateException("How can it be missing both?");
        }
        if (key.getKind() == null) {
            key.setKind(this.getCollectionName(key.getKindClass()));
        }
        return new DBRef(null, key.getKind(), key.getId());
    }

    public String updateKind(Key key) {
        if (key.getKind() == null && key.getKindClass() == null) {
            throw new IllegalStateException("Key is invalid! " + this.toString());
        }
        if (key.getKind() == null) {
            key.setKind(this.getMappedClass(key.getKindClass()).getCollectionName());
        }
        return key.getKind();
    }

    <T> Key<T> createKey(Class<T> clazz, Serializable id) {
        return new Key<T>(clazz, (Object)id);
    }

    <T> Key<T> createKey(Class<T> clazz, Object id) {
        if (id instanceof Serializable) {
            return this.createKey(clazz, (Serializable)id);
        }
        BSONEncoder enc = new BSONEncoder();
        return new Key<T>(clazz, enc.encode((BSONObject)this.toDBObject(id)));
    }

    public static MappedField validate(Class clazz, Mapper mapr, StringBuffer origProp, FilterOperator op, Object val, boolean validateNames, boolean validateTypes) {
        MappedField mf = null;
        String prop = origProp.toString();
        boolean hasTranslations = false;
        if (validateNames) {
            String[] parts = prop.split("\\.");
            if (clazz == null) {
                return null;
            }
            MappedClass mc = mapr.getMappedClass(clazz);
            int i = 0;
            while (true) {
                String part;
                if ((mf = mc.getMappedField(part = parts[i])) == null) {
                    mf = mc.getMappedFieldByJavaField(part);
                    if (mf == null) {
                        throw new ValidationException("The field '" + part + "' could not be found in '" + clazz.getName() + "' while validating - " + prop + "; if you wish to continue please disable validation.");
                    }
                    hasTranslations = true;
                    parts[i] = mf.getNameToStore();
                }
                ++i;
                if (mf.isMap()) {
                    ++i;
                }
                if (i < parts.length && !Mapper.canQueryPast(mf)) {
                    throw new ValidationException("Can not use dot-notation past '" + part + "' could not be found in '" + clazz.getName() + "' while validating - " + prop);
                }
                if (i >= parts.length) break;
                mc = mapr.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass());
            }
            if (hasTranslations) {
                origProp.setLength(0);
                origProp.append(parts[0]);
                for (i = 1; i < parts.length; ++i) {
                    origProp.append('.');
                    origProp.append(parts[i]);
                }
            }
            if (validateTypes && (mf.isSingleValue() && !Mapper.isCompatibleForOperator(mf.getType(), op, val) || mf.isMultipleValues() && !Mapper.isCompatibleForOperator(mf.getSubClass(), op, val) && !Mapper.isCompatibleForOperator(mf.getType(), op, val)) && log.isWarningEnabled()) {
                Throwable t = new Throwable();
                StackTraceElement ste = Mapper.getFirstClientLine(t);
                log.warning("The type(s) for the query/update may be inconsistent; using an instance of type '" + val.getClass().getName() + "' for the field '" + mf.getDeclaringClass().getName() + IGNORED_FIELDNAME + mf.getJavaFieldName() + "' which is declared as '" + mf.getType().getName() + (ste == null ? "'" : "'\r\n --@--" + ste));
                if (log.isDebugEnabled()) {
                    log.debug("Location of warning:\r\n", t);
                }
            }
        }
        return mf;
    }

    private static StackTraceElement getFirstClientLine(Throwable t) {
        for (StackTraceElement ste : t.getStackTrace()) {
            if (ste.getClassName().startsWith("com.google.code.morphia") || ste.getClassName().startsWith("sun.reflect") || ste.getClassName().startsWith("org.junit") || ste.getClassName().startsWith("org.eclipse") || ste.getClassName().startsWith("java.lang")) continue;
            return ste;
        }
        return null;
    }

    private static boolean canQueryPast(MappedField mf) {
        return !mf.hasAnnotation(Reference.class) && !mf.hasAnnotation(Serialized.class);
    }

    public static boolean isCompatibleForOperator(Class<?> type, FilterOperator op, Object value) {
        if (value == null || type == null) {
            return true;
        }
        if (op.equals((Object)FilterOperator.EXISTS) && value instanceof Boolean) {
            return true;
        }
        if (op.equals((Object)FilterOperator.IN) && (value.getClass().isArray() || Iterable.class.isAssignableFrom(value.getClass()) || Map.class.isAssignableFrom(value.getClass()))) {
            return true;
        }
        if (op.equals((Object)FilterOperator.NOT_IN) && (value.getClass().isArray() || Iterable.class.isAssignableFrom(value.getClass()) || Map.class.isAssignableFrom(value.getClass()))) {
            return true;
        }
        if (op.equals((Object)FilterOperator.ALL) && (value.getClass().isArray() || Iterable.class.isAssignableFrom(value.getClass()) || Map.class.isAssignableFrom(value.getClass()))) {
            return true;
        }
        if (value instanceof Integer && (Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Long.class.equals(type))) {
            return true;
        }
        if ((value instanceof Integer || value instanceof Long) && (Double.TYPE.equals(type) || Double.class.equals(type))) {
            return true;
        }
        if (value instanceof Pattern && String.class.equals(type)) {
            return true;
        }
        if (value.getClass().getAnnotation(Entity.class) != null && Key.class.equals(type)) {
            return true;
        }
        if (value instanceof List) {
            return true;
        }
        return value.getClass().isAssignableFrom(type) || value.getClass().getSimpleName().toLowerCase().equals(type.getSimpleName().toLowerCase());
    }

    public Class<?> getClassFromKind(String kind) {
        Set<MappedClass> mcs = this.mappedClassesByCollection.get(kind);
        if (mcs.isEmpty()) {
            throw new MappingException("The collection '" + kind + "' is not mapped to a java class.");
        }
        if (mcs.size() > 1 && log.isInfoEnabled()) {
            log.info("Found more than one class mapped to collection '" + kind + "'" + mcs);
        }
        return mcs.iterator().next().getClazz();
    }
}

