package de.accso.java8samples.beispiel2.functional_interfaces;

import junit.framework.TestCase;
import java.util.function.Predicate;

public class Beispiel2c_Predicate extends TestCase {
    public static void test() {
        Predicate<Integer> isEven = n -> n % 2 == 0;
        assertTrue(isEven.test(2));

        Predicate<Integer> isOdd = isEven.negate();
        assertFalse(isOdd.test(2));

        Predicate<Integer> isPositive = n -> n > 0;
        Predicate<Integer> isEvenAndPositive = isEven.and(isPositive);
        assertTrue(isEvenAndPositive.test(2));
        assertFalse(isEvenAndPositive.test(0));

        Predicate<Integer> isZero = n -> n == 0;
        Predicate<Integer> isZeroOrPositive = isPositive.or(isZero);
        assertTrue(isZeroOrPositive.test(0));
    }

    public static void main(String[] args) {
        Beispiel2c_Predicate.test(); // kein sichtbares Ergebnis
    }
}
