package de.heise.cmis;

import java.util.HashMap;
import java.util.Map;

import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.SessionParameter;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.BindingType;

/**
 * CMIS Client Beispiel
 *
 */
public class App 
{
	Session session;
  	String rootFolderId;
	
	public static void main( String[] args )
    {
        App myApp = new App();
		try {
        	System.out.println( "CMIS Client startet." );
			System.out.println( "Verbinden zum Repository..." );
			myApp.connect();
			myApp.printRepositoryInfo();
			myApp.getRootFolderChildren();
        	System.out.println( "CMIS Client beendet." );

        } catch (RuntimeException e) {
        	System.err.println("#### Error caused Exception: ");
        	System.err.println(e);
        }
    }
    
	private void connect() {
    	// default factory implementation of client runtime
    	SessionFactory f = SessionFactoryImpl.newInstance();
    	Map<String, String> parameter = new HashMap<String, String>();

    	// user credentials
    	parameter.put(SessionParameter.USER, "ix");
    	parameter.put(SessionParameter.PASSWORD, "ix");

    	// connection settings
    	// Fr AtomPub
    	parameter.put(SessionParameter.BINDING_TYPE, BindingType.ATOMPUB.value());
    	parameter.put(SessionParameter.REPOSITORY_ID, "A1");
    	parameter.put(SessionParameter.ATOMPUB_URL, "http://localhost:8080/inmemory/atom");
    	// Fr web services: 
//    	parameter.put(SessionParameter.BINDING_TYPE, BindingType.WEBSERVICES.value());
//    	parameter.put(SessionParameter.REPOSITORY_ID, "A1");
//    	parameter.put(SessionParameter.WEBSERVICES_ACL_SERVICE, "http://localhost:8080/inmemory/services/ACLService?wsdl");
//    	parameter.put(SessionParameter.WEBSERVICES_DISCOVERY_SERVICE, "http://localhost:8080/inmemory/services/DiscoveryService?wsdl");
//    	parameter.put(SessionParameter.WEBSERVICES_MULTIFILING_SERVICE, "http://localhost:8080/inmemory/services/MultiFilingService?wsdl");
//    	parameter.put(SessionParameter.WEBSERVICES_NAVIGATION_SERVICE, "http://localhost:8080/inmemory/services/NavigationService?wsdl");
//    	parameter.put(SessionParameter.WEBSERVICES_OBJECT_SERVICE, "http://localhost:8080/inmemory/services/ObjectService?wsdl");
//    	parameter.put(SessionParameter.WEBSERVICES_POLICY_SERVICE, "http://localhost:8080/inmemory/services/PolicyService?wsdl");
//    	parameter.put(SessionParameter.WEBSERVICES_RELATIONSHIP_SERVICE, "http://localhost:8080/inmemory/services/RelationshipService?wsdl");
//    	parameter.put(SessionParameter.WEBSERVICES_REPOSITORY_SERVICE, "http://localhost:8080/inmemory/services/RepositoryService?wsdl");
//    	parameter.put(SessionParameter.WEBSERVICES_VERSIONING_SERVICE, "http://localhost:8080/inmemory/services/VersioningService?wsdl");

    	// session locale
    	parameter.put(SessionParameter.LOCALE_ISO3166_COUNTRY, "");
    	parameter.put(SessionParameter.LOCALE_ISO639_LANGUAGE, "de");
    	parameter.put(SessionParameter.LOCALE_VARIANT, "");

    	// Session erzeugen
    	session = f.createSession(parameter);
    }
    
    private void printRepositoryInfo() {
    	RepositoryInfo repoInfo = session.getRepositoryInfo();
    	System.out.println("Repository Info: ");
      	System.out.println("Repository Id: " + repoInfo.getId());
      	System.out.println("Repository Name: " + repoInfo.getName());
      	System.out.println("Description: " + repoInfo.getDescription());
      	System.out.println("Product Name: " + repoInfo.getProductName());
      	System.out.println("Product Version: " + repoInfo.getProductVersion());
      	rootFolderId = repoInfo.getRootFolderId();
      	System.out.println("Root Folder Id: " + rootFolderId);
      	System.out.println();
    }
    
    private void getRootFolderChildren() {
    	Folder rootFolder = session.getRootFolder();
    	ItemIterable<CmisObject> children = rootFolder.getChildren();
      	System.out.println("Inhalt des Root Folders");
    	for (CmisObject obj: children) {
          	System.out.println("Name: " + obj.getName());
          	System.out.println("Id: " + obj.getId());
          	System.out.println("Basistyp: " + obj.getBaseType().getDisplayName());
          	System.out.println("Datum der letzten nderung: " + obj.getLastModificationDate().getTime());
          	System.out.println();
    	}    	
    }
}
