/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PortProvider;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningServiceImpl
extends AbstractWebServicesService
implements VersioningService {
    private final PortProvider fPortProvider;

    public VersioningServiceImpl(Session session, PortProvider portProvider) {
        this.setSession(session);
        this.fPortProvider = portProvider;
    }

    public void checkOut(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, ExtensionsData extension, org.apache.chemistry.opencmis.commons.spi.Holder<Boolean> contentCopied) {
        VersioningServicePort port = this.fPortProvider.getVersioningServicePort();
        try {
            Holder portObjectId = Converter.convertHolder(objectId);
            Holder portContentCopied = new Holder();
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.checkOut(repositoryId, portObjectId, portExtension, portContentCopied);
            Converter.setHolderValue((Holder)portObjectId, objectId);
            Converter.setHolderValue((Holder)portContentCopied, contentCopied);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        VersioningServicePort port = this.fPortProvider.getVersioningServicePort();
        try {
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.cancelCheckOut(repositoryId, objectId, portExtension);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void checkIn(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        VersioningServicePort port = this.fPortProvider.getVersioningServicePort();
        try {
            Holder portObjectId = Converter.convertHolder(objectId);
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.checkIn(repositoryId, portObjectId, major, Converter.convert((Properties)properties), Converter.convert((ContentStream)contentStream), checkinComment, policies, Converter.convert((Acl)addACEs), Converter.convert((Acl)removeACEs), portExtension);
            Converter.setHolderValue((Holder)portObjectId, objectId);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        VersioningServicePort port = this.fPortProvider.getVersioningServicePort();
        try {
            List versionList = port.getAllVersions(repositoryId, versionSeriesId, filter, includeAllowableActions, Converter.convert((ExtensionsData)extension));
            if (versionList == null) {
                return null;
            }
            ArrayList<ObjectData> result = new ArrayList<ObjectData>();
            for (CmisObjectType version : versionList) {
                result.add(Converter.convert((CmisObjectType)version));
            }
            return result;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        VersioningServicePort port = this.fPortProvider.getVersioningServicePort();
        try {
            return Converter.convert((CmisObjectType)port.getObjectOfLatestVersion(repositoryId, versionSeriesId, major, filter, includeAllowableActions, (EnumIncludeRelationships)Converter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeACL, Converter.convert((ExtensionsData)extension)));
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        VersioningServicePort port = this.fPortProvider.getVersioningServicePort();
        try {
            return Converter.convert((CmisPropertiesType)port.getPropertiesOfLatestVersion(repositoryId, versionSeriesId, major, filter, Converter.convert((ExtensionsData)extension)));
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }
}

