/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PortProvider;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyServicePort;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyServiceImpl
extends AbstractWebServicesService
implements PolicyService {
    private final PortProvider fPortProvider;

    public PolicyServiceImpl(Session session, PortProvider portProvider) {
        this.setSession(session);
        this.fPortProvider = portProvider;
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        PolicyServicePort port = this.fPortProvider.getPolicyServicePort();
        try {
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.applyPolicy(repositoryId, policyId, objectId, portExtension);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        PolicyServicePort port = this.fPortProvider.getPolicyServicePort();
        try {
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.removePolicy(repositoryId, policyId, objectId, portExtension);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        PolicyServicePort port = this.fPortProvider.getPolicyServicePort();
        try {
            List policyList = port.getAppliedPolicies(repositoryId, objectId, filter, Converter.convert((ExtensionsData)extension));
            ArrayList<ObjectData> result = new ArrayList<ObjectData>();
            if (policyList == null) {
                return result;
            }
            for (CmisObjectType policy : policyList) {
                result.add(Converter.convert((CmisObjectType)policy));
            }
            return result;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }
}

