/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.local.AbstractLocalService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
extends AbstractLocalService
implements RepositoryService {
    public RepositoryServiceImpl(Session session, CmisServiceFactory factory) {
        this.setSession(session);
        this.setServiceFactory(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            RepositoryInfo repositoryInfo = service.getRepositoryInfo(repositoryId, extension);
            return repositoryInfo;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        CmisService service = this.getService(null);
        try {
            List list = service.getRepositoryInfos(extension);
            return list;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            TypeDefinition typeDefinition = service.getTypeDefinition(repositoryId, typeId, extension);
            return typeDefinition;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            TypeDefinitionList typeDefinitionList = service.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, extension);
            return typeDefinitionList;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            List list = service.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, extension);
            return list;
        }
        finally {
            service.close();
        }
    }
}

