/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpiFactory;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AclServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.DiscoveryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.LinkCache;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.MultiFilingServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.NavigationServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.ObjectServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.PolicyServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.RelationshipServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.RepositoryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.VersioningServiceImpl;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmisAtomPubSpi
implements CmisSpiFactory,
CmisSpi {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(CmisAtomPubSpi.class);
    private Session session;
    private RepositoryService repositoryService;
    private NavigationService navigationService;
    private ObjectService objectService;
    private VersioningService versioningService;
    private DiscoveryService discoveryService;
    private MultiFilingService multiFilingService;
    private RelationshipService relationshipService;
    private PolicyService policyService;
    private AclService aclService;

    public CmisSpi getSpiInstance(Session session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing AtomPub SPI...");
        }
        this.session = session;
        this.repositoryService = new RepositoryServiceImpl(session);
        this.navigationService = new NavigationServiceImpl(session);
        this.objectService = new ObjectServiceImpl(session);
        this.versioningService = new VersioningServiceImpl(session);
        this.discoveryService = new DiscoveryServiceImpl(session);
        this.multiFilingService = new MultiFilingServiceImpl(session);
        this.relationshipService = new RelationshipServiceImpl(session);
        this.policyService = new PolicyServiceImpl(session);
        this.aclService = new AclServiceImpl(session);
        return this;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    public ObjectService getObjectService() {
        return this.objectService;
    }

    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public MultiFilingService getMultiFilingService() {
        return this.multiFilingService;
    }

    public RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public PolicyService getPolicyService() {
        return this.policyService;
    }

    public AclService getAclService() {
        return this.aclService;
    }

    public void clearAllCaches() {
        this.session.remove("org.apache.chemistry.opencmis.binding.atompub.linkcache");
    }

    public void clearRepositoryCache(String repositoryId) {
        LinkCache linkCache = (LinkCache)this.session.get("org.apache.chemistry.opencmis.binding.atompub.linkcache");
        if (linkCache != null) {
            linkCache.clearRepository(repositoryId);
        }
    }

    public void close() {
    }
}

