/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntryParser;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public class MultiFilingService {
    public static void removeObjectFromFolder(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String removeFrom = HttpUtils.getStringParameter(request, "removeFrom");
        AtomEntryParser parser = new AtomEntryParser((InputStream)request.getInputStream());
        String objectId = parser.getId();
        service.removeObjectFromFolder(repositoryId, objectId, removeFrom, null);
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        ObjectData object = objectInfo.getObject();
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        if (object.getId() == null) {
            throw new CmisRuntimeException("Object Id is null!");
        }
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        response.setStatus(201);
        response.setContentType("application/atom+xml;type=entry");
        response.setHeader("Location", AtomPubUtils.compileUrl(baseUrl, "entry", object.getId()));
        AtomEntry entry = new AtomEntry();
        entry.startDocument((OutputStream)response.getOutputStream());
        AtomPubUtils.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true);
        entry.endDocument();
    }
}

