/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.query;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CalendarHelper {
    private static final Pattern CMISQL_PATTERN = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})[Tt](\\d{2}):(\\d{2}):(\\d{2})(?:\\.(\\d+))?(?:[Zz]|([+-]\\d{2}:\\d{2}))");

    private CalendarHelper() {
    }

    public static GregorianCalendar fromString(String datetime) {
        Matcher m = CMISQL_PATTERN.matcher(datetime);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid datetime format: " + datetime);
        }
        String tz = m.group(8);
        GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT" + (tz == null ? "" : tz)));
        cal.set(1, Integer.parseInt(m.group(1)));
        cal.set(2, Integer.parseInt(m.group(2)) - 1);
        cal.set(5, Integer.parseInt(m.group(3)));
        cal.set(11, Integer.parseInt(m.group(4)));
        cal.set(12, Integer.parseInt(m.group(5)));
        cal.set(13, Integer.parseInt(m.group(6)));
        String decimals = m.group(7);
        int ms = decimals == null ? 0 : Integer.parseInt((decimals + "00").substring(0, 3));
        cal.set(14, ms);
        return cal;
    }

    public static String toString(Calendar cal) {
        StringBuilder buf = new StringBuilder(28);
        CalendarHelper.toString(cal, buf);
        return buf.toString();
    }

    public static void toString(Calendar cal, StringBuilder buf) {
        buf.append(cal.get(1));
        buf.append('-');
        int f = cal.get(2);
        if (f < 9) {
            buf.append('0');
        }
        buf.append(f + 1);
        buf.append('-');
        f = cal.get(5);
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        buf.append('T');
        f = cal.get(11);
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        buf.append(':');
        f = cal.get(12);
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        buf.append(':');
        f = cal.get(13);
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        buf.append('.');
        f = cal.get(14);
        if (f < 100) {
            buf.append('0');
        }
        if (f < 10) {
            buf.append('0');
        }
        buf.append(f);
        int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000;
        if (offset == 0) {
            buf.append('Z');
        } else {
            char sign;
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            } else {
                sign = '+';
            }
            buf.append(sign);
            f = offset / 60;
            if (f < 10) {
                buf.append('0');
            }
            buf.append(f);
            buf.append(':');
            f = offset % 60;
            if (f < 10) {
                buf.append('0');
            }
            buf.append(f);
        }
    }
}

