/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDecimal;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeValidator {
    public static void validateRequiredSystemProperties(Properties properties) {
        if (properties == null || properties.getProperties() == null) {
            throw new RuntimeException("Cannot create object, no properties are given");
        }
        if (!properties.getProperties().containsKey("cmis:objectTypeId")) {
            throw new RuntimeException("Cannot create object, type id is missing");
        }
    }

    private static boolean isMandatorySystemProperty(String propertyId) {
        return propertyId.equals("cmis:objectTypeId");
    }

    static <T> PropertyValidator<T> createPropertyValidator(PropertyDefinition<?> propDef) {
        PropertyValidator result = null;
        result = propDef instanceof PropertyIntegerDefinition ? new PropertyValidatorInteger() : (propDef instanceof PropertyDecimalDefinition ? new PropertyValidatorDecimal() : (propDef instanceof PropertyStringDefinition ? new PropertyValidatorString() : new PropertyValidator()));
        return result;
    }

    public static <T> void validateProperties(TypeDefinition typeDef, Properties properties, boolean checkMandatory) {
        List<String> propDefsRequired = TypeValidator.getMandatoryPropDefs(typeDef.getPropertyDefinitions());
        for (PropertyData prop : properties.getProperties().values()) {
            String propertyId = prop.getId();
            BaseTypeId baseTypeId = typeDef.getBaseTypeId();
            if (TypeValidator.isSystemProperty(baseTypeId, propertyId)) continue;
            if (!TypeValidator.typeContainsProperty(typeDef, propertyId)) {
                throw new CmisConstraintException("Unknown property " + propertyId + " in type " + typeDef.getId());
            }
            if (checkMandatory && propDefsRequired.contains(propertyId)) {
                propDefsRequired.remove(propertyId);
            }
            PropertyDefinition<T> propDef = TypeValidator.getPropertyDefinition(typeDef, propertyId);
            PropertyValidator<T> validator = TypeValidator.createPropertyValidator(propDef);
            validator.validate(propDef, prop);
        }
        if (checkMandatory && !propDefsRequired.isEmpty()) {
            throw new CmisConstraintException("The following mandatory properties are missing: " + propDefsRequired);
        }
    }

    public static void validateVersionStateForCreate(DocumentTypeDefinition typeDef, VersioningState verState) {
        if (null == verState) {
            return;
        }
        if (typeDef.isVersionable().booleanValue() && verState.equals((Object)VersioningState.NONE) || !typeDef.isVersionable().booleanValue() && !verState.equals((Object)VersioningState.NONE)) {
            throw new CmisConstraintException("The versioning state flag is imcompatible to the type definition.");
        }
    }

    public static void validateAllowedChildObjectTypes(TypeDefinition childTypeDef, List<String> allowedChildTypes) {
        if (null == allowedChildTypes) {
            return;
        }
        for (String allowedChildType : allowedChildTypes) {
            if (!allowedChildType.equals(childTypeDef.getId())) continue;
            return;
        }
        throw new RuntimeException("The requested type " + childTypeDef.getId() + " is not allowed in this folder");
    }

    private static List<String> getMandatoryPropDefs(Map<String, PropertyDefinition<?>> propDefs) {
        ArrayList<String> res = new ArrayList<String>();
        if (null != propDefs) {
            for (PropertyDefinition<?> propDef : propDefs.values()) {
                if (!propDef.isRequired().booleanValue() || TypeValidator.isMandatorySystemProperty(propDef.getId())) continue;
                res.add(propDef.getId());
            }
        }
        return res;
    }

    public static boolean typeContainsProperty(TypeDefinition typeDef, String propertyId) {
        Map propDefs = typeDef.getPropertyDefinitions();
        if (null == propDefs) {
            return false;
        }
        PropertyDefinition propDef = (PropertyDefinition)propDefs.get(propertyId);
        return null != propDef;
    }

    public static boolean typeContainsPropertyWithQueryName(TypeDefinition typeDef, String propertyQueryName) {
        Map propDefs = typeDef.getPropertyDefinitions();
        if (null == propDefs) {
            return false;
        }
        for (PropertyDefinition propDef : propDefs.values()) {
            if (!propDef.getQueryName().toLowerCase().equals(propertyQueryName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static <T> PropertyDefinition<T> getPropertyDefinition(TypeDefinition typeDef, String propertyId) {
        Map propDefs = typeDef.getPropertyDefinitions();
        if (null == propDefs) {
            return null;
        }
        PropertyDefinition propDef = (PropertyDefinition)propDefs.get(propertyId);
        if (null == propDef) {
            return null;
        }
        return propDef;
    }

    private static boolean isSystemProperty(BaseTypeId baseTypeId, String propertyId) {
        if (propertyId.equals("cmis:name")) {
            return true;
        }
        if (propertyId.equals("cmis:objectId")) {
            return true;
        }
        if (propertyId.equals("cmis:objectTypeId")) {
            return true;
        }
        if (propertyId.equals("cmis:baseTypeId")) {
            return true;
        }
        if (propertyId.equals("cmis:createdBy")) {
            return true;
        }
        if (propertyId.equals("cmis:creationDate")) {
            return true;
        }
        if (propertyId.equals("cmis:lastModifiedBy")) {
            return true;
        }
        if (propertyId.equals("cmis:lastModificationDate")) {
            return true;
        }
        if (propertyId.equals("cmis:changeToken")) {
            return true;
        }
        if (baseTypeId.equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
            if (propertyId.equals("cmis:isImmutable")) {
                return true;
            }
            if (propertyId.equals("cmis:isLatestVersion")) {
                return true;
            }
            if (propertyId.equals("cmis:isMajorVersion")) {
                return true;
            }
            if (propertyId.equals("cmis:versionSeriesId")) {
                return true;
            }
            if (propertyId.equals("cmis:isLatestMajorVersion")) {
                return true;
            }
            if (propertyId.equals("cmis:versionLabel")) {
                return true;
            }
            if (propertyId.equals("cmis:versionSeriesId")) {
                return true;
            }
            if (propertyId.equals("cmis:isVersionSeriesCheckedOut")) {
                return true;
            }
            if (propertyId.equals("cmis:versionSeriesCheckedOutBy")) {
                return true;
            }
            if (propertyId.equals("cmis:versionSeriesCheckedOutId")) {
                return true;
            }
            if (propertyId.equals("cmis:checkinComment")) {
                return true;
            }
            if (propertyId.equals("cmis:contentStreamLength")) {
                return true;
            }
            if (propertyId.equals("cmis:contentStreamMimeType")) {
                return true;
            }
            if (propertyId.equals("cmis:contentStreamFileName")) {
                return true;
            }
            return propertyId.equals("cmis:contentStreamId");
        }
        if (baseTypeId.equals((Object)BaseTypeId.CMIS_FOLDER)) {
            if (propertyId.equals("cmis:parentId")) {
                return true;
            }
            if (propertyId.equals("cmis:allowedChildObjectTypeIds")) {
                return true;
            }
            return propertyId.equals("cmis:path");
        }
        if (baseTypeId.equals((Object)BaseTypeId.CMIS_POLICY)) {
            if (propertyId.equals("cmis:sourceId")) {
                return true;
            }
            return propertyId.equals("cmis:targetId");
        }
        return propertyId.equals("cmis:policyText");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyValidatorString
    extends PropertyValidator<String> {
        PropertyValidatorString() {
        }

        @Override
        public void validate(PropertyDefinition<String> propDef, PropertyData<String> property) {
            long len;
            super.validate(propDef, property);
            long maxLen = ((PropertyStringDefinition)propDef).getMaxLength() == null ? -1L : ((PropertyStringDefinition)propDef).getMaxLength().longValue();
            long l = len = property.getFirstValue() == null ? -1L : (long)((String)property.getFirstValue()).length();
            if (maxLen >= 0L && len >= 0L && maxLen < len) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the length of " + len + "is bigger than the maximum allowed length  " + maxLen);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyValidatorDecimal
    extends PropertyValidator<BigDecimal> {
        PropertyValidatorDecimal() {
        }

        @Override
        public void validate(PropertyDefinition<BigDecimal> propDef, PropertyData<BigDecimal> property) {
            super.validate(propDef, property);
            BigDecimal propVal = (BigDecimal)((PropertyDecimal)property).getFirstValue();
            BigDecimal minVal = ((PropertyDecimalDefinition)propDef).getMinValue();
            BigDecimal maxVal = ((PropertyDecimalDefinition)propDef).getMaxValue();
            if (minVal != null && propVal != null && propVal.compareTo(minVal) == -1) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the value " + propVal + " is less than the minimum value " + minVal);
            }
            if (maxVal != null && propVal != null && propVal.compareTo(maxVal) == 1) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the value " + propVal + " is bigger than the maximum value " + maxVal);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyValidatorInteger
    extends PropertyValidator<BigInteger> {
        PropertyValidatorInteger() {
        }

        @Override
        public void validate(PropertyDefinition<BigInteger> propDef, PropertyData<BigInteger> property) {
            super.validate(propDef, property);
            BigInteger propVal = (BigInteger)((PropertyInteger)property).getFirstValue();
            BigInteger minVal = ((PropertyIntegerDefinition)propDef).getMinValue();
            BigInteger maxVal = ((PropertyIntegerDefinition)propDef).getMaxValue();
            if (minVal != null && propVal != null && propVal.compareTo(minVal) == -1) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the value " + propVal + " is less than the minimum value " + minVal);
            }
            if (maxVal != null && propVal != null && propVal.compareTo(maxVal) == 1) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the value " + propVal + " is bigger than the maximum value " + maxVal);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyValidator<T> {
        PropertyValidator() {
        }

        public void validate(PropertyDefinition<T> propDef, PropertyData<T> prop) {
            if (propDef.getCardinality() == Cardinality.SINGLE && prop.getValues().size() > 1) {
                throw new CmisConstraintException("The property with id " + propDef.getId() + " is single valued, but multiple values are passed " + prop.getValues());
            }
            if (propDef.getChoices() != null && propDef.getChoices().size() > 0) {
                this.validateChoices(propDef, prop);
            }
        }

        private void validateChoices(PropertyDefinition<T> propDef, PropertyData<T> prop) {
            boolean isAllowedValue = true;
            boolean hasMultiValueChoiceLists = false;
            for (Choice allowedValue : propDef.getChoices()) {
                if (allowedValue.getValue() == null || allowedValue.getValue().size() <= 1) continue;
                hasMultiValueChoiceLists = true;
            }
            if (hasMultiValueChoiceLists) {
                isAllowedValue = false;
                List actualValues = prop.getValues();
                for (Choice allowedValue : propDef.getChoices()) {
                    if (allowedValue.getValue().size() == actualValues.size()) {
                        boolean listValuesAreEqual = true;
                        Iterator it = allowedValue.getValue().iterator();
                        for (Object actualValue : actualValues) {
                            if (actualValue.equals(it.next())) continue;
                            listValuesAreEqual = false;
                            break;
                        }
                        if (listValuesAreEqual) {
                            isAllowedValue = true;
                        }
                    }
                    if (!isAllowedValue) continue;
                    break;
                }
            } else {
                List<T> allowedValues = this.getAllowedValues(propDef.getChoices());
                for (Object actualValue : prop.getValues()) {
                    if (allowedValues.contains(actualValue)) continue;
                    isAllowedValue = false;
                    break;
                }
            }
            if (!isAllowedValue) {
                throw new CmisConstraintException("The property with id " + propDef.getId() + " has a fixed set of values. Value(s) " + prop.getValues() + " are not listed.");
            }
        }

        private List<T> getAllowedValues(List<Choice<T>> choices) {
            ArrayList<Object> allowedValues = new ArrayList<Object>(choices.size());
            for (Choice<T> choice : choices) {
                if (choice.getValue() != null) {
                    allowedValues.add(choice.getValue().get(0));
                }
                if (choice.getChoice() == null) continue;
                List x = choice.getChoice();
                allowedValues.addAll(this.getAllowedValues(x));
            }
            return allowedValues;
        }
    }
}

