package net.eisele.forkjoin;

import java.util.logging.Logger;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

/**
 * Find a City within the MaxMind World Cities with Population Database textfile
 * Get your Copy here: http://www.maxmind.com/app/worldcities
 * @author eiselem
 */
public class FindCity {

    private final static Logger LOG = Logger.getLogger(FindCity.class.getName());
    private final static String city = ".*Hannover.*";

    /**
     *  Main 
     * @param args
     * @throws IOException
     * @throws NoSuchMethodException
     * @throws IllegalAccessException
     * @throws Throwable
     */
    public static void main(String[] args) throws IOException, NoSuchMethodException, IllegalAccessException, Throwable {
        String[] input = readLinesFromFile("worldcitiespop.txt");
        String query = city;

        // Fork join run
        long start = System.currentTimeMillis();
        WorldCitiesScanner scanner = new WorldCitiesScanner(input);
        Set<String> matches = scanner.scan(query);
        long end = System.currentTimeMillis();

        for (String match : matches) {
            LOG.log(Level.INFO, "Teilergebnis: {0}", match);
        }

        LOG.log(Level.INFO, "Number of matches  : {0}", matches.size());
        LOG.log(Level.INFO, "Elapsed (ForkJoin) : {0} seconds", ((end - start) * 0.001));

        // Naive sequential run
        start = System.currentTimeMillis();
        matches = naive(input, query);
        end = System.currentTimeMillis();
        LOG.log(Level.INFO, "\nNumber of matches  : {0}", matches.size());
        LOG.log(Level.INFO, "Elapsed (naive)    : {0} seconds", ((end - start) * 0.001));



    }

    private static Set<String> naive(String[] input, String query) {
        Pattern pattern = Pattern.compile(query);

        Set<String> matches = new HashSet<>();
        for (int i = 0; i < input.length; i++) {
            if (pattern.matcher(input[i]).matches()) {
                matches.add(input[i]);
            }
        }

        return matches;
    }

    private static String[] readLinesFromFile(String file) throws IOException {
        List<String> lines =
                Files.readAllLines(Paths.get(file), Charset.forName("iso-8859-1"));
        return lines.toArray(new String[lines.size()]);
    }
}
