#include <EEPROM.h>
#include <SPI.h>
#include <GD2.h>

#include "heise.h"

const unsigned int LOGO_TAG = 42;

unsigned int logo_x;
unsigned int logo_y;

void setup() {
  GD.begin();
  LOAD_ASSETS();
  set_logo_position();
}

void loop() {
  GD.ClearColorRGB(0xffffff);
  GD.Clear();
  
  GD.Begin(BITMAPS);
  GD.Tag(LOGO_TAG);
  GD.Vertex2ii(logo_x, logo_y, HEISE_HANDLE, 0);
  
  GD.ColorRGB(0x444444);
  GD.cmd_text(240, 136, 30, OPT_CENTER, "c't Hardware Hacks");
  
  GD.get_inputs();
  if (GD.inputs.tag == LOGO_TAG)
    set_logo_position();
  
  GD.swap();
}

void set_logo_position() {
  logo_x = GD.random(480 - HEISE_WIDTH);
  logo_y = GD.random(272 - HEISE_HEIGHT);
}

