#include <OneWire.h>
#include <DallasTemperature.h>

const unsigned long BAUD_RATE = 9600;
const unsigned char ONE_WIRE_BUS = 4;

OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensoren(&oneWire);

void setup() {
  sensoren.begin();
  Serial.begin(BAUD_RATE);
  Serial.print("Anzahl Sensoren: ");
  Serial.println(sensoren.getDeviceCount());
  Serial.print("Modus ist: ");
  if (sensoren.isParasitePowerMode()) {
    Serial.println("Parasitär");
  } else {
    Serial.println("Normal");
  }
}

void loop() {
  sensoren.requestTemperatures();
  float temperatur = sensoren.getTempCByIndex(0);
  Serial.println(temperatur);
  delay(1000);
}

