// HDD Clock 1
// Ulrich Schmerold
// 01/2015
// 


#include <Wire.h> 
#include <Time.h> 
#include <DS1307RTC.h>  // Library für das RTC-Modul

#define RED           5  // Pin, an dem die rote LED angeschlossen ist (an PORTD)
#define GRN           6  // Pin, an dem die grüne LED angeschlossen ist (an PORTD)
#define BLU           7  // Pin, an dem die blaue LED angeschlossen ist (an PORTD)
#define Taste_Stunde 11  // Pin, an dem die Taste für Stundeneinstellung hängt
#define Taste_Minute 12  // Pin, an dem die Taste für Minuteneinstellung hängt

#define BREITE_STUNDENZEIGER    3  // Wie breit soll der Stundenzeiger sein
#define BREITE_MINUTENZEIGER    2  // Wie breit soll der Minutenzeiger sein
#define BREITE_SEKUNDENZEIGER   1  // Wie breit soll der Sekundenzeiger sein
#define BREITE_SCHATTEN         1  // Breite sollder Schattens der Zeiger sein(0 für keinen Schatten)

#define VERSCHIEBUNG 36        // Verschiebung der Uhr, da die Lichtschranke meist nicht auf 12 Uhr sitzt

// Mit diesem Makro werden aus dem einzelnen Farben der Farb-Wert für den PortD berechnet
#define RGB(R,G,B)      (R << RED | G << GRN | B << BLU)

#define   Startannimationen  true  //Sollen beim Start der Uhr Annimationen angezeit werden

#define SHOW_SCALA false        // Soll ein Ziffernblatt dargestellt werden
#define ANAZAHL_TEILER  4       // Wie viele Segmente soll das Ziffernblatt haben

int RED_1 = 1;  // Hintergrundbeleuchtung rot
int GRN_1 = 0;  // Hintergrundbeleuchtung grün
int BLU_1 = 0;  // Hintergrundbeleuchtung blau

boolean button_state_stunde = false; // Status der Stundentaste 
boolean button_state_minute = false; // Status der Minutentaste 
boolean button_pressed      = false; // Flag für gedrückte Tasten

byte Seitenpuffer [2] [256];          // Array für die einzelnen Segmente 
volatile byte aktuelles_segment;    // Der Sektor, der momentan beleuchtet wird
int Dauer_Umlauf;                   // Die Zeitdauer einer Umdrehung in Pozessortakten
volatile byte Hintergrundseite;     // Index für die Hintergrundeite
volatile byte Sichtbare_Seite;      // Index für die Sichtbare Seite

volatile boolean Anforderung_Seitentausch; // Flag, das din Seitenwechsel auslöst

tmElements_t Zeit;  // Variable für die RTC-Zeit

void setup(void)
{
  // LED Ports als Ausgang definieren
  pinMode(RED, OUTPUT);
  pinMode(GRN, OUTPUT);
  pinMode(BLU, OUTPUT);
  
  // Tasten Ports für Zeiteinstellung als Eingang mit PullUp Widerstand
  pinMode(Taste_Stunde,INPUT_PULLUP);
  pinMode(Taste_Minute,INPUT_PULLUP);
  
  //Interrupts und Timer initialisieren  
  Configure_Interrupts();
 
  // Annimationen zum Start der Uhr
 if (Startannimationen == true) 
 {
    Annimation_1();
    ClearePage_animated();
    Annimation_2();
    ClearePage_animated();
    Annimation_3();
    ClearePage_animated();
    Annimation_4();
    ClearePage_animated();
 } 
}


void loop(void)
{
  // Zeit einstellen  --------------------------------
  button_state_stunde = digitalRead(Taste_Stunde);              // Taste Stunde abfragen
  button_state_minute = digitalRead(Taste_Minute);              // Taste Minute abfragen
  if (button_state_stunde == LOW || button_state_minute == LOW)
  {
    if (button_pressed==false)                                  // wurde die Taste vorher losgelassen?
    {                               
      if(button_state_stunde == true) incStunde();              // Uhrzeit um eine Stunde  vorstellen
      if(button_state_minute == true) incMinute();              // Uhrzeit um eine Minute  vorstellen
      button_pressed = true;                                    // Tasten-Flag setzen
    }
    //-------------------------------------------------
  } else {
    show_time();                     // Uhrzeit anzeigen
    button_pressed = false;          // Tasten-Flag zurücksetzen
  }
}


//----------------------------------- Uhrzeit anzeigen
void show_time(void){
 int sector;  
 
 loesche_Seite();

  //-------------------------- Hintergrundbeleuchtung
  for (int i = 0; i < 256; i++)
  {                   
    Zeichne_Segment(i, RGB(RED_1,GRN_1,BLU_1));
  }
  
  // -----------------------------   Scala anzeigen
 if (SHOW_SCALA == true)
 {
    int div = (256 / ANAZAHL_TEILER);
    for (int x =0; x < ANAZAHL_TEILER; x++)
    {
       sector = (x * div);
       Zeichne_Zeiger(sector,RGB(!RED_1,!GRN_1,!BLU_1),1); // als Farbe wird das Gegenteil von der Hintergrundbeleuchtung genommen
    }
 }  

  RTC.read(Zeit);   // Zeit vom RTC-Modul abrufen und in tm speichern
  int h = Zeit.Hour;  
  int m = Zeit.Minute;
  int s = Zeit.Second;

  //--------------------  Sekundenzeiger ---------------------------------------------
  if (s > 0)
  {
    sector = (256 * (s / 60.0));
  } else sector=0; 
  Zeichne_Zeiger_mit_Schatten(sector,RGB(1,1,1),BREITE_SEKUNDENZEIGER,BREITE_SCHATTEN);   

  //--------------------  Stundenzeiger 
  if (h >= 12)  h = h - 12; 

  if (h>0) {
    sector = (256 * (h / 12.0) );
  } else sector=0;
  
  if (m > 0) sector=sector+(256 * m /720);   //den Anteil zur vollen Stunde hinzufügen
  Zeichne_Zeiger_mit_Schatten(sector, RGB(0,1,0),BREITE_STUNDENZEIGER,BREITE_SCHATTEN);   

  //--------------------  Minutenzeiger 
  if (m > 0) 
  {
     sector = (256 * (m / 60.0));
  } else sector=0;
     Zeichne_Zeiger_mit_Schatten(sector,RGB(0,0,1),BREITE_MINUTENZEIGER,BREITE_SCHATTEN); 
  //----------------------------------------------------------------------------------------  
  tausche_Seiten();
  kopiere_Seite();
}


// leitet einen Tausch von sichbarer gegen Hintergrundseite ein
void tausche_Seiten(void)
{
    Anforderung_Seitentausch = true;
    while (Anforderung_Seitentausch==true) {} // Warten bis Signal von der Lichtschranke (interrupt) kommt
}

// kopiert die momentan dargestellt Seite in die Hintergrundseite
void kopiere_Seite(void)
{
    for(int x = 0; x < 256; x++)
    {
        Seitenpuffer[Hintergrundseite][x] = Seitenpuffer[Sichtbare_Seite][x];
    }
}

// Zeichnet einen Sektor in die Hintergrundseite
void Zeichne_Segment(byte slice, byte val)
{   
   if ( slice > 256)  slice=slice-256;            // Sicherstellen, dass Wert nicht  größer als die Sektorenanzahl ist
   if ( slice < 0)    slice=slice+256;            // Sicherstellen, dass Wert nicht  kleiner 0 ist
   Seitenpuffer[Hintergrundseite][slice] = val;   // Farbwert diese Position in den Puffer schreiben
}

// löscht den Hintergrundpuffer
void loesche_Seite(void)
{
    for(int x = 0; x < 256; x += 1)
    {
        Seitenpuffer[Hintergrundseite][x] = 0;
    }
}


// Hier werden sie Sichtbare- und die Hintergrundseite getauscht
void interchange_page(void)
{
    if (Anforderung_Seitentausch==true)
    {
        Sichtbare_Seite = Hintergrundseite;
        Hintergrundseite = !Hintergrundseite;
        Anforderung_Seitentausch = false;
    }
}

// Blendet die Anzeige segmentweise aus
void ClearePage_animated(void)
{
  for(int x = 0; x < 256; x++)
  {
     Zeichne_Segment(x, 0);
     tausche_Seiten();
     kopiere_Seite();
  }         
}

// Annimation zeigt die 3 Farben als wachsende Segmente
void Annimation_1(void)
{
    int color;
    int Segment;

    loesche_Seite();
    tausche_Seiten();

    for (color = 0; color < 3; color++)
    {
        for (Segment = 0; Segment < 256; Segment ++)
        {
            switch(color)
            {
                case 0:
                    Zeichne_Segment(Segment, RGB(1,0,0));
                    break;
                case 1:
                    Zeichne_Segment(Segment,RGB(0,1,0));
                    break;
                case 2:
                    Zeichne_Segment(Segment, RGB(0,0,1));
                    break;
            }
            tausche_Seiten();
            kopiere_Seite();
        }
    }
}


// Annimation zeigt alle möglichen Farbkombinationen
void Annimation_2(void)
{
  int Segment;
  loesche_Seite();

  for(Segment = 0; Segment < 256; Segment++)
  {
      switch (Segment / (256 / 8))
      {
        case 0:
          Zeichne_Segment(Segment, RGB(0,0,0));
          break;  
        case 1:
          Zeichne_Segment(Segment, RGB(1,0,0));
          break;
        case 2:
          Zeichne_Segment(Segment, RGB(0,1,0));
          break;
        case 3:
          Zeichne_Segment(Segment, RGB(0,0,1));
          break;
        case 4:
          Zeichne_Segment(Segment, RGB(1,1,0));
          break;  
        case 5:
          Zeichne_Segment(Segment, RGB(1,0,1));
          break;  
        case 6:
          Zeichne_Segment(Segment, RGB(0,1,1));
          break;  
        case 7:
        default:
          Zeichne_Segment(Segment, RGB(1,1,1));
          break;
      }         
     tausche_Seiten();
     kopiere_Seite();
    }
}

// Annimation zeigt alle darstellbaren Segmente.
void Annimation_3(void)
{
  int Segment;
  loesche_Seite();
  for(Segment = 0; Segment < 256; Segment++)
  {
      switch (Segment % 4)
      {
        case 0:
          Zeichne_Segment(Segment, RGB(0,0,0));
          break;  
        case 1:
          Zeichne_Segment(Segment, RGB(1,0,0));
          break;
        case 2:
          Zeichne_Segment(Segment, RGB(0,1,0));
          break;
        case 3:
          Zeichne_Segment(Segment, RGB(0,0,1));
          break;
     }
       tausche_Seiten();
       kopiere_Seite();
    }
}

// Annimation zeigt nettes, rotierendes Bild.
void Annimation_4(void)
{
  int i;
  int Segment;
  for (int ii  =  0  ;  ii  <  500  ;  ii++  )
  {  
    for ( Segment = 0 ; Segment < 226  ; Segment=Segment+(256 /8))
    {
       for (i = 0; i < 10; i++)  Zeichne_Segment(i+Segment+ii, RGB(1,0,0));
        for (i = 10; i < 17; i++)Zeichne_Segment(i+Segment+ii, RGB(0,0,0));
       for (i = 17; i < 19; i++)  Zeichne_Segment(i+Segment+ii, RGB(0,1,0));
        for (i = 20; i < 21; i++)Zeichne_Segment(i+Segment+ii, RGB(0,0,0));
       for (i = 21; i < 23; i++)  Zeichne_Segment(i+Segment+ii, RGB(0,0,1));
        for (i = 23; i < 256 /8; i++)Zeichne_Segment(i+Segment+ii, RGB(0,0,0));
    }
    tausche_Seiten();
  }
}


// Zeichnet einen Zeiger in der übergebenen Farbe und Breite
void Zeichne_Zeiger(byte pos, byte Farbe, byte Breite_Zeiger )
{
  for( int i = -Breite_Zeiger ; i < Breite_Zeiger ; i++)
  {    
      int real_pos = pos + i + VERSCHIEBUNG;
      Zeichne_Segment(real_pos, Farbe);
  } 
}


// Zeichnet einen Zeiger in der übergebenen Farbe und Breite
// Die Ränder werden  mit schwarzem Schatten ergänzt
void Zeichne_Zeiger_mit_Schatten(byte pos, byte Farbe, byte Breite_Zeiger, byte Breite_Schatten )
{
  for (int s=1;s<=Breite_Schatten;s++)
  {
    Zeichne_Segment((pos+VERSCHIEBUNG-Breite_Zeiger-s), RGB(0,0,0)); 
  }
   
  for( int i = -Breite_Zeiger ; i < Breite_Zeiger ; i++)
  {    
      int real_pos = pos + i + VERSCHIEBUNG;
      Zeichne_Segment(real_pos, Farbe);
  } 
  
  for ( int s = 1 ; s <= Breite_Schatten ; s++)
  {
    Zeichne_Segment((pos+VERSCHIEBUNG+Breite_Zeiger+s-1), RGB(0,0,0)); 
  }
}


// Zeit um eine Minute vorstellen und im RTC Modul abspeichern
void incMinute()
{ 
  RTC.read(Zeit);     // Zeit vom RTC-Modul abrufen und in tm speichern
  int h = Zeit.Hour;  
  int m = Zeit.Minute;
  setTime(h,(m+1),0,16,02,15); // stelle Uhr auf h:m+1:00, und das Datum auf 16.02.15
  RTC.set (now());
}

// Zeit um eine Stunde vorstellen und im RTC Modul abspeichern
void incStunde()
{ 
  RTC.read(Zeit);   // Zeit vom RTC-Modul abrufen und in tm speichern
  int h = Zeit.Hour;  
  int m = Zeit.Minute;
  setTime((h+1),m,0,16,02,15); // stelle Uhrzeit auf h+1:m:00, und das Datum auf 16.02.15
  RTC.set (now());
}


//----------------------------------------------------------------
//                           Interrupts
//----------------------------------------------------------------

// Hilfsmakro zum Setzen von Bits
#define bitset(var,bitno) ((var) |= (1 << (bitno)))

// Timer und Interrupts konfigurieren
void Configure_Interrupts(void)
{
  cli();    // Interrupts ausschalten

  //  timer0 - 8bit
  // verantwortlich für das Timing der LED's
  TCCR0A = 0;
  TCCR0B = 0;  
  bitset(TCCR0A, WGM01);   // CTC mode
  bitset(TCCR0B, CS01);    //  prescaler clk / 8
  bitset(TIMSK0, OCIE0A);  // compare interrupt

  
  //  time1 - 16bit
  //  aus diesem Timer wird die Anzahl der Prozessortackte pro Umdrehung ermittelt
  TCCR1B = 0;
  TCCR1A = 0;
  bitset(TCCR1B, CS11);   //  prescaler clk / 8
  TCNT1 = 0;              // Timer auf 0 setzen
  bitset(TIMSK1, TOIE1);  //  overflow interrupt


  // Konfiguration vom Lichtschranken-PIN
  EICRA = _BV(ISC01);
  EIMSK |= _BV(INT0);  // Hardware interrupt ein

  sei();  // Interrupts einschalten
}


// Dieses Interupt wird bei jeder Umdrehung der Platte ausgelöst
// Hier werden die beiden Timer auf 0 gesetzt
// und der Seitentausch ausgelöst
ISR(INT0_vect)
{
  // Wie lange ist seit dem letztem Lichtschrankenimpuls vergangen?
  Dauer_Umlauf = TCNT1;

  // 16 bit Timer auf 0 setzen (timer1)
  TCNT1 = 0;
  // 8 bit Timer auf 0 setzen (timer0) 
  TCNT0 = 0;
  // If there is a page flip request, flip to the next page
  interchange_page();
  // Den 1. Sektor an die LEDs senden
  PORTD = Seitenpuffer[Sichtbare_Seite][0];
  aktuelles_segment = 1;
  // Berechnen, wie lange ein Sektor ist
  OCR0A = (Dauer_Umlauf / 256);
}


// Dises Interrupt wird vom 8bit Timer ausgelößt.
// Das Timerintervall wird nach jedem Auslösen der Lichtschranke berechnet
// und an das OCROA- Register übergeben
ISR(TIMER0_COMPA_vect) {
  // Sektorweise die gespeicherten Werte der LED an die Ports ausgeben
  PORTD = Seitenpuffer[Sichtbare_Seite][aktuelles_segment];
  // Nächster Sektor
  aktuelles_segment ++;
}



