const int triggerPin = 8; 
const int echoPin = 9; 

long zeit, abstand; 
int maxAbstand = 400; //Abstandswerte über 400 cm werden verworfen 
void setup() {
 Serial.begin (9600);	//um das Ergebnis im Monitor anzusehen 
 pinMode(triggerPin, OUTPUT);
 pinMode(echoPin, INPUT);
 }

void loop() {
   digitalWrite(triggerPin, LOW); //erst wird der Triggerpin auf 'Low' gesetzt
   delayMicroseconds(2); 
  
   digitalWrite(triggerPin, HIGH); //ein 10 µs langes Triggersignal veranlasst das Modul 8 Ultraschall Pulse bei 40 kHz auszusenden 
   delayMicroseconds(10); 
   digitalWrite(triggerPin, LOW);
   //der Echopin gibt die Zeit, die das reflektierte Signal braucht um am Sensor anzukommen aus indem er eben diese Länge auf 'High' gesetzt wird. Die Funktion pulseIn(x,HIGH) gibt die Dauer eines Pulses in Mikrosekunden zurück.
   zeit = pulseIn(echoPin, HIGH); 
   
   //Der Abstand (in cm) lässt sich dann folgendermaßen ausrechnen. Dafür wurde die Abstandsformel oben in Mikrosekunden und Zentimeter umgewandelt.
   abstand = zeit/58.3;
   if (abstand <= maxAbstand){   
     Serial.println(abstand);//der gemessene Abstand wird dann im seriellen Monitor ausgegeben.
   }  
   //Die nächste Messung wird 100 ms später gestartet.
   delay(100);
}
