// In der Funktion "setup()" wird die serielle Verbindung zum Arduino
// manuell gesetzt, z.B. "COM20" auf einem Windows-PC.

import processing.serial.*;

RectButton btnP1, btnP10;
RectButton btnM1, btnM10;


Serial comPort;
String  message  = null;
boolean ledState = false;
boolean locked   = false;

int iBtn = 0;

void setup()
{ // zeige alle verfügbaren seriellen Verbindungen  
  println( Serial.list());
  // Verbindung mit "COM20",
  // hier muss die Verbindung zum Arduino eingetragen sein.
  comPort = new Serial( this, "COM20", 9600);
  
  frame.setResizable( true);
  frame.setTitle( "Ardino-PWM-Meter");

  size( 320, 240);
  smooth();
  background( 255,0,0);

  textFont( createFont( "Verdana", 16, true), 16);
  text( "+1", 110, 18);

  textFont( createFont( "Verdana", 16, true), 16);
  text( "-1", 160, 18);

  textFont( createFont( "Verdana", 16, true), 16);
  text( "+10", 110, 88);

  textFont( createFont( "Verdana", 16, true), 16);
  text( "-10", 160, 88);
  
  btnP1  = new RectButton( 100, 20, 50, color( 45), color( 50));
  btnM1  = new RectButton( 150, 20, 50, color( 255), color( 100));
  btnP10 = new RectButton( 100, 90, 50, color(45), color( 50));
  btnM10 = new RectButton( 150, 90, 50, color( 255), color( 100));

}

void draw()
{ update( mouseX, mouseY);

  btnP1.display();
  btnM1.display();

  btnP10.display();
  btnM10.display();
}

void update( int x, int y)
{ if ( locked == false)
  { btnP1.update();
    btnM1.update();
    btnP10.update();
    btnM10.update();
  }
  else 
  { locked = false;
  }

  if ( mousePressed)
  { if ( btnP1.pressed())
    { if ( iBtn != 1)
      { int i = 1;
        comPort.write( '1');
        iBtn = i;
      }
    }
    else if ( btnM1.pressed())
    { if ( iBtn != 2)
      { int i = 2;
        comPort.write( '2');
        iBtn = i;
      }
    }
    else if ( btnP10.pressed())
    { if ( iBtn != 3)
      { int i = 3;
        comPort.write( '3');
        iBtn = i;
      }
    }
    else if ( btnM10.pressed())
    { if ( iBtn != 4)
      { int i = 4;
        comPort.write( '4');
        iBtn = i;
      }
    }
  }
}

void mousePressed()
{ iBtn = 0;
}

void serialEvent( Serial p)
{ message = comPort.readStringUntil( 13);

  if ( message != null)
  {
    try
    { println( message);
    }
    catch ( Exception e)
    { println( e);
    }
  }
}

class Button
{ int x, y, size;

  color basecolor, highlightcolor;

  color currentcolor;

  boolean over    = false;
  boolean pressed = false;

  void update()
  { if( over()) 
    { currentcolor = highlightcolor;
    }
    else 
    { currentcolor = basecolor;
    }
  }

  boolean pressed()
  { if( over) 
    { locked = true;

      return true;
    }
    else 
    { locked = false;

      return false;
    }
  }

  boolean over()
  { return true;
  }

  boolean overRect( int x, int y, int width, int height)
  { if ( mouseX >= x && mouseX <= x + width 
      && mouseY >= y && mouseY <= y + height) 
    { return true;
    }
    else 
    { return false;
    }
  }
}

class RectButton extends Button
{ RectButton( int ix, int iy, int isize, color icolor, color ihighlight)
  { x = ix;
    y = iy;
    size = isize;

    basecolor = icolor;
    highlightcolor = ihighlight;
    currentcolor = basecolor;
  }

  boolean over()
  { if( overRect( x, y, size, size) ) 
    { over = true;

      return true;
    }
    else 
    { over = false;

      return false;
    }
  }

  void display()
  { stroke( 255);
    fill( currentcolor);
    rect( x, y, size, size);
  }
}
