#include "aquarium_monitor.h"
#include "temp_sensor.h"

void AquariumMonitor::setup() {
  ofHideCursor();
  _elapsed_time = ofGetElapsedTimeMillis();
  _show_info = false;
  _screen_counter = 1;
  _background_image.loadImage("aquarium.jpg");
  ofTrueTypeFont::setGlobalDpi(72);
  _verdana.loadFont("verdana.ttf", 30, true, true);
  _verdana.setLineHeight(34.0f);
  _verdana.setLetterSpacing(1.035);
  _mono.loadFont("mono.ttf", 30, true, true);
  _mono.setLineHeight(34.0f);
  _mono.setLetterSpacing(1.035);
  get_temperature();
}

void AquariumMonitor::update() {
  unsigned long long current_time = ofGetElapsedTimeMillis();
  if (current_time - _elapsed_time >= 60 * 1000) {
    _elapsed_time = current_time;
    get_temperature();
  }
}

void AquariumMonitor::draw() {
  _background_image.draw(0, 0);
  ofEnableAlphaBlending();
  ofSetColor(255, 255, 255, 200);
  _verdana.drawString(std::string("Wassertemperatur: ") + std::string(_current_temp), 30, 35);
  std::string format_string = "%H:%M";
  if (ofGetSeconds() % 2) {
    format_string = "%H %M";
  }
  _mono.drawString(ofGetTimestampString(format_string), 1750, 35);
  show_info();
  ofDisableAlphaBlending();
}

void AquariumMonitor::get_temperature() {
  TemperatureSensor temp_sensor("/sys/bus/w1/devices/28-000004f21649/w1_slave");
  sprintf(_current_temp, "%.1f C", temp_sensor.get_temperature());
}

