/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import moppydesk.OutputSetting;
import moppydesk.outputs.MoppyCOMBridge;
import moppydesk.ui.MoppyControlWindow;

public class ChannelOutControl
extends JPanel {
    private OutputSetting settings;
    private MoppyControlWindow controlWindow;
    private JRadioButton MIDITypeRB;
    private JComboBox comComboBox;
    private JCheckBox enabledCB;
    private JComboBox midiOutComboBox;
    private JLabel midiOutLabel;
    private JRadioButton moppyTypeRB;
    private ButtonGroup outputTypeRB;

    public ChannelOutControl(MoppyControlWindow mcw, OutputSetting os) {
        this.settings = os;
        this.controlWindow = mcw;
        this.initComponents();
        this.loadSettings();
    }

    private void loadSettings() {
        if (this.settings.enabled) {
            this.enabledCB.setSelected(true);
            this.enableControls();
        } else {
            this.enabledCB.setSelected(false);
            this.disableControls();
        }
        if (this.settings.type.equals((Object)OutputSetting.OutputType.MOPPY)) {
            this.moppyTypeRB.setSelected(true);
            this.outputTypeChanged(OutputSetting.OutputType.MOPPY);
        } else {
            this.MIDITypeRB.setSelected(true);
            this.outputTypeChanged(OutputSetting.OutputType.MIDI);
        }
        this.comComboBox.setSelectedItem(this.settings.comPort);
        this.midiOutComboBox.setSelectedItem(this.settings.midiDeviceName);
    }

    public void lockControl() {
        this.enabledCB.setEnabled(false);
        this.disableControls();
    }

    public void unlockControl() {
        this.enabledCB.setEnabled(true);
        this.enableControls();
    }

    private void disableControls() {
        this.moppyTypeRB.setEnabled(false);
        this.MIDITypeRB.setEnabled(false);
        this.comComboBox.setEnabled(false);
        this.midiOutComboBox.setEnabled(false);
    }

    private void enableControls() {
        this.moppyTypeRB.setEnabled(true);
        this.MIDITypeRB.setEnabled(true);
        if (this.moppyTypeRB.isSelected()) {
            this.outputTypeChanged(new ActionEvent(this.moppyTypeRB, 1001, this.moppyTypeRB.getActionCommand()));
        } else if (this.MIDITypeRB.isSelected()) {
            this.outputTypeChanged(new ActionEvent(this.MIDITypeRB, 1001, this.MIDITypeRB.getActionCommand()));
        }
    }

    private void initComponents() {
        this.outputTypeRB = new ButtonGroup();
        this.moppyTypeRB = new JRadioButton();
        this.MIDITypeRB = new JRadioButton();
        this.comComboBox = new JComboBox();
        this.midiOutComboBox = new JComboBox();
        this.midiOutLabel = new JLabel();
        this.enabledCB = new JCheckBox();
        this.setPreferredSize(new Dimension(525, 23));
        this.outputTypeRB.add(this.moppyTypeRB);
        this.moppyTypeRB.setText("Moppy");
        this.moppyTypeRB.setToolTipText("Sends Moppy-protocol serial data to selected COM port");
        this.moppyTypeRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChannelOutControl.this.outputTypeChanged(evt);
            }
        });
        this.outputTypeRB.add(this.MIDITypeRB);
        this.MIDITypeRB.setText("MIDI");
        this.MIDITypeRB.setToolTipText("Sends MIDI messages through to selected MIDI port");
        this.MIDITypeRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChannelOutControl.this.outputTypeChanged(evt);
            }
        });
        this.comComboBox.setModel(new DefaultComboBoxModel<String>(MoppyCOMBridge.getAvailableCOMPorts()));
        this.comComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChannelOutControl.this.comComboBoxActionPerformed(evt);
            }
        });
        this.midiOutComboBox.setModel(new DefaultComboBoxModel<String>(this.controlWindow.availableMIDIOuts.keySet().toArray(new String[0])));
        this.midiOutComboBox.setEnabled(false);
        this.midiOutComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChannelOutControl.this.midiOutComboBoxActionPerformed(evt);
            }
        });
        this.midiOutLabel.setText("MIDI Out:");
        this.midiOutLabel.setEnabled(false);
        this.enabledCB.setText(String.valueOf(this.settings.MIDIChannel));
        this.enabledCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChannelOutControl.this.enabledCBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.enabledCB, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.moppyTypeRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MIDITypeRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comComboBox, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 104, Short.MAX_VALUE).addComponent(this.midiOutLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.midiOutComboBox, -2, 130, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moppyTypeRB).addComponent(this.MIDITypeRB).addComponent(this.comComboBox, -2, -1, -2).addComponent(this.midiOutComboBox, -2, -1, -2).addComponent(this.midiOutLabel).addComponent(this.enabledCB))));
    }

    private void comComboBoxActionPerformed(ActionEvent evt) {
        this.settings.comPort = (String)((JComboBox)evt.getSource()).getSelectedItem();
    }

    private void midiOutComboBoxActionPerformed(ActionEvent evt) {
        this.settings.midiDeviceName = (String)((JComboBox)evt.getSource()).getSelectedItem();
    }

    private void enabledCBActionPerformed(ActionEvent evt) {
        this.settings.enabled = ((JCheckBox)evt.getSource()).isSelected();
        if (this.settings.enabled) {
            this.enableControls();
        } else {
            this.disableControls();
        }
    }

    private void outputTypeChanged(OutputSetting.OutputType newType) {
        this.settings.type = newType;
        if (newType.equals((Object)OutputSetting.OutputType.MOPPY)) {
            this.midiOutLabel.setEnabled(false);
            this.midiOutComboBox.setEnabled(false);
            this.comComboBox.setEnabled(true);
        } else {
            this.comComboBox.setEnabled(false);
            this.midiOutLabel.setEnabled(true);
            this.midiOutComboBox.setEnabled(true);
        }
    }

    private void outputTypeChanged(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("Moppy")) {
            this.outputTypeChanged(OutputSetting.OutputType.MOPPY);
        } else {
            this.outputTypeChanged(OutputSetting.OutputType.MIDI);
        }
    }
}

