/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.testing;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import moppydesk.outputs.MoppyPlayerOutput;
import moppydesk.testing.FloppySimWindow;

public class MoppyCOMsumer
implements Runnable,
SerialPortEventListener {
    SerialPort currentPort = null;
    InputStream currentInputStream = null;
    boolean running = false;
    FloppySimWindow fsw;

    public MoppyCOMsumer(FloppySimWindow fsw) {
        this.fsw = fsw;
    }

    public void run() {
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(MoppyCOMsumer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void openPort(String portId) throws NoSuchPortException, PortInUseException, IOException, TooManyListenersException, UnsupportedCommOperationException {
        if (this.currentPort != null) {
            this.currentPort.close();
            this.currentPort = null;
            this.currentInputStream = null;
        }
        CommPortIdentifier cpi = CommPortIdentifier.getPortIdentifier(portId);
        this.currentPort = (SerialPort)cpi.open("MoppyFloppySim", 2000);
        this.currentInputStream = this.currentPort.getInputStream();
        this.currentPort.addEventListener(this);
        this.currentPort.notifyOnDataAvailable(true);
        this.currentPort.setSerialPortParams(9600, 8, 1, 0);
    }

    public void serialEvent(SerialPortEvent spe) {
        switch (spe.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                byte[] readBuffer = new byte[20];
                try {
                    while (this.currentInputStream.available() > 2) {
                        int pin = this.currentInputStream.read();
                        byte[] payload = new byte[2];
                        this.currentInputStream.read(payload);
                        long loopPeriod = (payload[0] & 0xFF) << 8 | payload[1] & 0xFF;
                        if (loopPeriod > 0L) {
                            long microPeriod = loopPeriod * (long)MoppyPlayerOutput.ARDUINO_RESOLUTION * 2L;
                            double frequency = 1000000L / microPeriod;
                            this.fsw.displayNote(pin, String.valueOf(frequency) + "Hz");
                            continue;
                        }
                        this.fsw.displayNote(pin, "");
                    }
                    System.out.print(new String(readBuffer));
                    break;
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
    }
}

