/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.testing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import moppydesk.testing.FloppyDisplay;
import moppydesk.testing.MoppyFloppySim;

public class FloppySimWindow
extends JFrame {
    MoppyFloppySim app;
    HashMap<Integer, FloppyDisplay> displays = new HashMap();
    private JComboBox comComboBox;
    private JPanel drivesPanel;
    private JLabel jLabel1;

    FloppySimWindow(MoppyFloppySim app) {
        this.app = app;
        this.initComponents();
        this.setupDrivesPanel();
    }

    private void setupDrivesPanel() {
        this.displays.clear();
        this.drivesPanel.removeAll();
        for (int p = 2; p <= 16; p += 2) {
            FloppyDisplay newDisplay = new FloppyDisplay(p / 2, p);
            this.displays.put(p, newDisplay);
            this.drivesPanel.add(newDisplay);
        }
    }

    public void displayNote(int pin, String note) {
        if (this.displays.containsKey(pin)) {
            this.displays.get(pin).setNote(note);
        }
    }

    public String getSelectedCOM() {
        return (String)this.comComboBox.getSelectedItem();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.comComboBox = new JComboBox();
        this.drivesPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Moppy Floppy Simulator");
        this.setMinimumSize(new Dimension(500, 350));
        this.jLabel1.setText("Listen on:");
        FloppySimWindow floppySimWindow = this;
        this.comComboBox.setModel(new DefaultComboBoxModel<String>(floppySimWindow.app.getAvailableCOMPorts()));
        this.comComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FloppySimWindow.this.comComboBoxActionPerformed(evt);
            }
        });
        this.drivesPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.drivesPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comComboBox, -2, 74, -2).addGap(0, 356, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.drivesPanel, -1, 282, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void comComboBoxActionPerformed(ActionEvent evt) {
        String comPort = (String)((JComboBox)evt.getSource()).getSelectedItem();
        try {
            this.app.mCom.openPort(comPort);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.rootPane, ex);
            Logger.getLogger(FloppySimWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

