/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.outputs;

import gnu.io.SerialPort;
import javax.sound.midi.MidiMessage;
import moppydesk.outputs.MoppyCOMBridge;
import moppydesk.outputs.MoppyReceiver;

public class MoppyPlayerOutput
implements MoppyReceiver {
    public static int[] microPeriods = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30578, 28861, 27242, 25713, 24270, 22909, 21622, 20409, 19263, 18182, 17161, 16198, 15289, 14436, 13621, 12856, 12135, 11454, 10811, 10205, 9632, 9091, 8581, 8099, 7645, 7218, 6811, 6428, 6068, 5727, 5406, 5103, 4816, 4546, 4291, 4050, 3823, 3609, 3406, 3214, 3034, 2864, 2703, 2552, 2408, 2273, 2146, 2025, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int ARDUINO_RESOLUTION = 40;
    private int[] currentPeriod = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    MoppyCOMBridge mb;
    SerialPort com;

    public MoppyPlayerOutput(MoppyCOMBridge newMb) {
        this.mb = newMb;
    }

    public void close() {
        this.mb.resetDrives();
        this.mb.close();
    }

    public void send(MidiMessage message, long timeStamp) {
        if (message.getStatus() > 127 && message.getStatus() < 144) {
            byte pin = (byte)(2 * (message.getStatus() - 127));
            this.mb.sendEvent(pin, 0);
            this.currentPeriod[message.getStatus() - 128] = 0;
        } else if (message.getStatus() > 143 && message.getStatus() < 160) {
            byte pin = (byte)(2 * (message.getStatus() - 143));
            int period = microPeriods[message.getMessage()[1] & 0xFF] / (ARDUINO_RESOLUTION * 2);
            if (message.getMessage()[2] == 0) {
                this.mb.sendEvent(pin, 0);
                this.currentPeriod[message.getStatus() - 144] = 0;
            } else {
                this.mb.sendEvent(pin, period);
                this.currentPeriod[message.getStatus() - 144] = period;
            }
        } else if (message.getStatus() > 223 && message.getStatus() < 240 && this.currentPeriod[message.getStatus() - 224] != 0) {
            byte pin = (byte)(2 * (message.getStatus() - 223));
            double pitchBend = ((message.getMessage()[2] & 0xFF) << 8) + (message.getMessage()[1] & 0xFF);
            int period = (int)((double)this.currentPeriod[message.getStatus() - 224] / Math.pow(2.0, (pitchBend - 8192.0) / 8192.0));
            this.mb.sendEvent(pin, period);
        }
    }

    public void reset() {
        this.mb.resetDrives();
    }
}

