/*
 * Decompiled with CFR 0.152.
 */
package moppydesk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import moppydesk.inputs.MoppyMIDIInput;
import moppydesk.inputs.MoppySequencer;
import moppydesk.outputs.ReceiverMarshaller;
import moppydesk.ui.MoppyControlWindow;
import org.jdesktop.application.SingleFrameApplication;

public class MoppyUI
extends SingleFrameApplication {
    public MoppySequencer ms;
    public MoppyMIDIInput midiIn;
    public ReceiverMarshaller rm = new ReceiverMarshaller();
    public Preferences prefs = Preferences.userNodeForPackage(MoppyUI.class);

    protected void startup() {
        try {
            this.ms = new MoppySequencer();
            this.midiIn = new MoppyMIDIInput();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.getMainFrame(), ex.toString());
        }
        MoppyControlWindow mainWindow = new MoppyControlWindow(this);
        mainWindow.setStatus("Initializing...");
        this.show(mainWindow);
        mainWindow.setStatus("Initialized.");
    }

    public static void main(String[] args) {
        MoppyUI.launch(MoppyUI.class, args);
    }

    public void savePreferences() {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(MoppyUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void putPreferenceObject(String key, Object object) {
        try {
            this.prefs.putByteArray(key, MoppyUI.serializePref(object));
        }
        catch (IOException ex) {
            Logger.getLogger(MoppyUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Object getPreferenceObject(String key) {
        try {
            return MoppyUI.deserializePref(this.prefs.getByteArray(key, null));
        }
        catch (NullPointerException ex) {
            Logger.getLogger(MoppyUI.class.getName()).log(Level.WARNING, "No preference set for " + key, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MoppyUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MoppyUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private static Object deserializePref(byte[] b) throws NullPointerException, IOException, ClassNotFoundException {
        return new ObjectInputStream(new ByteArrayInputStream(b)).readObject();
    }

    private static byte[] serializePref(Object p) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(p);
        oos.close();
        return baos.toByteArray();
    }
}

