/*
 Software serial test - modified July 16, 2013 for Servo shield
 
 last change: October 19,2013
 
 Receives from the hardware serial, sends to software serial.
 
 The circuit: 
 * RX is digital pin 10 (connect to TX of other device)
 * TX is digital pin 11 (connect to RX of other device)
 
 This example code is in the public domain.
 
 */
#include <SoftwareSerial.h>

SoftwareSerial mySerial(10, 11); // RX, TX

void setup()  
{
  // Open serial communications and wait for port to open:
  Serial.begin(9600);
  Serial.println("Welcome to Servo shield test application");
  // set the data rate for the SoftwareSerial port
  mySerial.begin(9600);
}

void loop() // run over and over
{
  // receive command and forward to servo shield
  while (Serial.available()) {
    mySerial.write(Serial.read()); // forward whatever we get... 
  }  
  // receive response - if available - and forward to host computer
  while (mySerial.available()) {
    Serial.write(mySerial.read());
  }  
}
