/*
 Joystick Sketch for SSC
 read joystick position, echo value to terminal and sent value to SSC
*/

#include <SoftwareSerial.h>

SoftwareSerial mySerial(10, 11); // RX, TX

const int ch1Pin = 0; // select the input pin for channel 1
const int ch2Pin = 1; // select the input pin for channel 2
const int ch3Pin = 2; // select the input pin for channel 3
const int ch4Pin = 3; // select the input pin for channel 4

int ch1Val = 127;     // inital value for channel (center)
int ch2Val = 127;     // inital value for channel (center)
int ch3Val = 127;     // inital value for channel (center)
int ch4Val = 127;     // inital value for channel (center)

int val;

void setPulseLength (int iChannel, int bPulseLength) {
  if ((iChannel >0) && (iChannel <= 8)) {
    mySerial.write(byte(0xFF));                  // synch token
    mySerial.write(byte(iChannel-1));            // channel number
    mySerial.write(bPulseLength);                // channel number    
  }  
}



void setup()
{
  Serial.begin(9600);
  mySerial.begin(9600);
}


void loop()
{
  // channel 1 processing
  val = map(analogRead(ch1Pin), 0, 1023, 0, 254);
  if (ch1Val != val) 
  {
    ch1Val = val;
    Serial.print("Channel 1 reads: ");
    Serial.println(ch1Val);
    setPulseLength(1,ch1Val);
  }
  // channel 2 processing
  val = map(analogRead(ch2Pin), 0, 1023, 0, 254);
  if (ch2Val != val) 
  {
    ch2Val = val;
    Serial.print("Channel 2 reads: ");
    Serial.println(ch2Val);     
    setPulseLength(2,ch2Val);
  }
  // channel 3 processing
  val = map(analogRead(ch3Pin), 0, 1023, 0, 254);
  if (ch3Val != val) 
  {
    ch3Val = val;
    Serial.print("Channel 3 reads: ");
    Serial.println(ch3Val);
    setPulseLength(3,ch3Val);
  }
  // channel 4 processing
  val = map(analogRead(ch4Pin), 0, 1023, 0, 254);
  if (ch4Val != val) 
  {
    ch4Val = val;
    Serial.print("Channel 4 reads: ");
    Serial.println(ch4Val);
    setPulseLength(4,ch4Val);

  }
}

