//-----------------------------------------------------------------------------
//  OS.h
/// @file OS.h
///
/// @brief Header for the file OS.c
///
/// This is the header for the file OS.c.
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-02-10 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __OS_H
 #define __OS_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------
#include "Basetyp.h"

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------
// OS_STATE return value definitions
/// Functionstate: ok
#define ERR_OS_OK                      0x01
/// Functionstate: Task is cannot created
#define ERR_OS_TASK_NOT_CREATED        0x02
/// Functionstate: Task has no message queue
#define ERR_OS_TASK_HAS_NO_MSG_QUEUE   0x03
/// Functionstate: Queue full
#define ERR_OS_QUEUE_FULL              0x04
/// Functionstate: Queue is empty
#define ERR_OS_QUEUE_EMPTY             0x05
/// Functionstate: Queue cannot created
#define ERR_OS_QUEUE_NOT_CREATED       0x06
/// Functionstate: Semaphore cannot created
#define ERR_OS_SEMAPHORE_NOT_CREATED   0x07
/// Functionstate: Task has no semaphore
#define ERR_OS_TASK_HAS_NO_SEMAPHORE   0x08
/// Functionstate: Semaphore take failed
#define ERR_OS_SEMAPHORE_TAKE_FAILED   0x09
/// Functionstate: Mutex cannot created 
#define ERR_OS_MUTEX_NOT_CREATED       0x0A
/// Functionstate: Mutex take failed
#define ERR_OS_MUTEX_TAKE_FAILED       0x0B
/// Functionstate: Task has no mutex
#define ERR_OS_TASK_HAS_NO_MUTEX       0x0C

// Waittime definitions
/// Waittime: Return immediately
#define RETURN_IMMEDIATELY             0
/// Waittime: Wait until event is occur
#define WAIT_MAX                       0xffffffff

/// OS_STATE typedefinition
typedef UBYTE  OS_STATE;

/// Defintion of the message structure
typedef struct tagMESSAGE
{
   UBYTE    MessageID;        ///< Id of the message
   UBYTE *  pMessageData;     ///< Data of the message (This is a already a
                              ///< pointer. If pMessageData is not equal zero
                              ///< the memory is freeing after processing the 
                              ///< messgae.)
} MESSAGE;

/// Defintion of the TASK_ID enum
typedef enum tagTASK_ID
{
   TASK_ID_PROCESS_M = 0,     ///< Id of the central process task
   TASK_ID_MEASURE_M,         ///< Id of the measurement task
   TASK_ID_LED_M,             ///< Id of the led task for the simple user
                              ///< interface
   TASK_ID_COM_M,             ///< Id of the communication task
   TASK_ID_FLASHMEM_M         ///< Id of the memory task
} TASK_ID;

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------
// Startfunction for the os
void OS_StartOS( void );
// Creating all tasks for the application
void OS_CreateAllTasks( void );
// Send a message to a task
OS_STATE OS_SendMessage( TASK_ID TaskID, MESSAGE * pMessage, UDWORD TicksToWait );
// Send a message to a task (nonblocking)
OS_STATE OS_SendMessageNB( TASK_ID TaskID, MESSAGE * pMessage);
// Receive a message
OS_STATE OS_ReceiveMessage( TASK_ID TaskID, MESSAGE * pMessage, UDWORD TicksToWait );
// Receive a message (nonblocking)
OS_STATE OS_ReceiveMessageNB( TASK_ID TaskID, MESSAGE * pMessage );
// Give a semaphore from ISR
OS_STATE OS_SemaphoreGiveFromISR( TASK_ID TaskID );
// Take a semaphore
OS_STATE OS_SemaphoreTake( TASK_ID TaskID, UDWORD BlockTime );
// Sleepfunction
OS_STATE OS_Sleep( UDWORD Time_ms );
// Give a mutex
OS_STATE OS_MutexGive( TASK_ID TaskID );
// Take a mutex
OS_STATE OS_MutexTake( TASK_ID TaskID, UDWORD BlockTime );
// Enable the interrupts
OS_STATE OS_EnableInterrupts();
// Disable the interrupts
OS_STATE OS_DisableInterrupts();

#endif //__OS_H
