//-----------------------------------------------------------------------------
//  MessageDefs.h
/// @file MessageDefs.h
///
/// @brief Definitions for the internal application messages
///
/// Definitions for the internal application messages
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-02-14 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __MESSAGEDEFS_H
 #define __MESSAGEDEFS_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------

// Internal commands

/// Initial init message for all task in the application
#define MSG_INIT_SYSTEM                   0x01
/// A key action is detectet
#define MSG_KEY_ACTION                    0x02
/// Show a led value
#define MSG_SHOW_VALUE                    0x03
/// Request config data
#define MSG_REQ_CONFIG_DATA               0x05
/// Config data
#define MSG_CONFIG_DATA                   0x06
/// Create a new measure file
#define MSG_CREATE_NEW_MEASURE_FILE       0x07
/// Close the active measure file
#define MSG_CLOSE_ACTIVE_FILE             0x08
/// Insert a new dataset in the active measure file
#define MSG_INSERT_DATASET_IN_FILE        0x09
/// Clear all the measure files
#define MSG_CLEAR_ALL_MEASURE_FILES       0x0A
/// Request flash memory information
#define MSG_REQ_FALSHMEM_INFO             0x0B
/// Flash memory information
#define MSG_FALSHMEM_INFO                 0x0C
/// Request device information
#define MSG_REQ_DEVICE_INFO               0x0D
/// Device information
#define MSG_DEVICE_INFO                   0x0E
/// Write the device configuration data
#define MSG_WRITE_DEVICE_CONFIG_DATA      0x0F
/// A new data block on the uart is received
#define MSG_UART_DB_RECEIVED              0x10
/// Request the device configuration
#define MSG_REQ_DEVICE_CONFIG             0x11
/// Device configuration
#define MSG_DEVICE_CONFIG                 0x12
/// Request the actual measure values
#define MSG_REQ_ACTUAL_MVALUES            0x13
/// Actual measure values
#define MSG_ACTUAL_MVALUES                0x14
/// Reset the extreme values
#define MSG_RESET_MVALUES                 0x15
/// Request Read the config data 
#define MSG_REQ_READ_DEVICE_CONFIG_DATA   0x16
/// Readed config data
#define MSG_READ_DEVICE_CONFIG_DATA       0x17
/// Measure mode
#define MSG_MEASURE_MODE                  0x18
/// Request the measure mode
#define MSG_REQ_MEASURE_MODE              0x19
/// Clear all data files
#define MSG_CLEAR_ALL_DATA_FILES          0x1A
/// Format the file system
#define MSG_FORMAT_FILE_SYSTEM            0x1B
/// Number of files in the file system
#define MSG_NUM_OF_FILES_IN_FFS           0x1C
/// Request an ffs file
#define MSG_REQ_FFS_FILE                  0x1E
/// File system block
#define MSG_FFS_FILE_BLOCK                0x1F
/// Start the ffs file transfer
#define MSG_START_FFS_FILE_TRANSFER       0x20
/// Get the next file block
#define MSG_GET_NEXT_FFS_FILE_BLOCK       0x23
/// FFS File is EOF
#define MSG_FFS_FILE_EOF                  0x24
/// Enable the bluetooth module
#define MSG_ENABLE_BLUETOOTH              0x25
/// Sets an led job
#define MSG_SET_LED_JOB                   0x26

/// Definition of the enum for identify the led
typedef enum tagLEDM_LED_NAME
{
   LN_RED = 0,                                  ///< Id red led
   LN_GREEN,                                    ///< Id green led
   LN_YELLOW,                                   ///< Id yellow led
   LN_LAST = LN_YELLOW                          ///< Last entry in the led list
} LED_NAME;

/// Definition of the enum for controlling the led state
typedef enum tagLED_STATE
{
   LS_OFF = 0,                                  ///< State led off
   LS_ON,                                       ///< State led on
   LS_FLASH                                     ///< State led flash
} LED_STATE;

/// Measurement mode of the system
typedef enum tagMEASURE_MODE
{
   MM_NORMAL = 0,                               ///< Normal mode
   MM_LOGGING                                   ///< Logging mode
} MEASURE_MODE;

/// Defintion of the data structure of the message MSG_INSERT_DATASET
typedef struct tagMSG_DATA_INSERT_DATASET
{
   unsigned int            TimestampHi;         ///< hi-nibble of the timestamp of the last measurement
   unsigned int            TimestampLo;         ///< lo-nibble of the timestamp of the last measurement
   float                   ActualAltitude;      ///< altitude in meters
   float                   ActualPressure;      ///< pressure in pascal
   float                   ActualTemperature;   ///< temperature in degree celcius
   float                   ActualAccXDir;       ///< acceleration in X dir in g
   float                   ActualAccYDir;       ///< acceleration in Y dir in g
   float                   ActualAccZDir;       ///< acceleration in Z dir in g
} MSG_DATA_INSERT_DATASET;

/// Defintion of the data structure of the message MSG_SHOW_VALUE
typedef struct tagMSG_DATA_SHOW_VALUE
{
   float                   Value;               ///< Data value to show
} MSG_DATA_SHOW_VALUE;

/// Defintion of the data structure of the message MSG_NUM_OF_FILES_IN_FFS
typedef struct tagMSG_DATA_NUM_OF_FILES_IN_FFS
{
   UWORD                   NumOfFilesInFFS;     ///< Number of files in file system
} MSG_DATA_NUM_OF_FILES_IN_FFS;

/// Defintion of the data structure of the message MSG_CREATE_NEW_MEASURE_FILE
typedef struct tagMSG_DATA_CREATE_NEW_MEASURE_FILE
{
   UWORD                   Temperature;         ///< Temperature
} MSG_DATA_CREATE_NEW_MEASURE_FILE;

/// Defintion of the data structure of the message MSG_MEASURE_MODE
typedef struct tagMSG_DATA_MEASURE_MODE
{
   UBYTE                   MeasureMode;         ///< Measure mode
} MSG_DATA_MEASURE_MODE;

/// Defintion of the data structure of the message MSG_ENABLE_BLUETOOTH
typedef struct tagMSG_DATA_ENABLE_BLUETOOTH
{
   UBYTE                   EnableBluetooth;     ///< Flag enable bluetooth
} MSG_DATA_ENABLE_BLUETOOTH;

/// Defintion of the data structure of the message MSG_REQ_FFS_FILE
typedef struct tagMSG_DATA_REQ_MEASURE_FILE
{
   UWORD                   FileNumber;          ///< Number of the file (file id)
   UWORD                   MaxBlockSize;        ///< maximal block size for the transfer
} MSG_DATA_REQ_MEASURE_FILE;

/// Defintion of the data structure of the message MSG_REQ_FFS_FILE
typedef struct tagMSG_DATA_REQ_FFS_FILE
{
   UWORD                   FileNumber;          ///< Number of the file (file id)
   UWORD                   MaxBlockSize;        ///< maximal block size for the transfer
} MSG_DATA_REQ_FFS_FILE;

/// Defintion of the data structure of the message MSG_FFS_FILE_BLOCK
typedef struct tagMSG_DATA_FFS_FILE_BLOCK
{
   PUBYTE                  MemoryHandle;        ///< Handle to the file block data
   UWORD                   SizeOfFFSFileBlock;  ///< Size of the file block
} MSG_DATA_FFS_FILE_BLOCK;

/// Defintion of the data structure of the message MSG_FFS_FILE_BLOCK
typedef struct tagMSG_DATA_MEASURE_FILE_BLOCK
{
   PUBYTE                  MemoryHandle;        ///< Handle to the file block data
   UWORD                   SizeOfMeasureFileBlock;///< Size of the file block
} MSG_DATA_MEASURE_FILE_BLOCK;

/// Defintion of the data structure of the message MSG_START_FFS_FILE_TRANSFER
typedef struct tagMSG_DATA_START_FFS_FILE_TRANSFER
{
   UWORD                   TotalNumOfDataBlocks;///< Total number of data blocks
   UDWORD                  NumOfDataInFile;     ///< Number of data bytes in the file
} MSG_DATA_START_FFS_FILE_TRANSFER;

/// Defintion of the data structure of the message MSG_START_FFS_FILE_TRANSFER
typedef struct tagMSG_DATA_START_MEASURE_FILE_TRANSFER
{
   UWORD                   TotalNumOfDataBlocks;///< Total number of data blocks
   UDWORD                  NumOfDataInFile;     ///< Number of data bytes in the file
} MSG_DATA_START_MEASURE_FILE_TRANSFER;

/// Defintion of the data structure of the message MSG_FALSHMEM_INFO
typedef struct tagMSG_DATA_FALSHMEM_INFO
{
   UBYTE                   FlashSize;           ///< Size of the flashmemory
   UBYTE                   FlashDeviceType;     ///< Type of the flashmemory
} MSG_DATA_FALSHMEM_INFO;

/// Defintion of the data structure of the message MSG_DEVICE_INFO
typedef struct tagMSG_DATA_DEVICE_INFO
{
   UBYTE                  CPU_UnigueID[16];     ///< Unique id of the cpu
   UDWORD                 CPU_DeviceID;         ///< Device id of the cpu
   MSG_DATA_FALSHMEM_INFO FlashMemInfo;         ///< Flash memory info
   UBYTE                  SWVersion;            ///< Software version
   UBYTE                  SWRevision;           ///< Software revision
   UBYTE                  SWSubRevision;        ///< Software subrevision
   UBYTE                  HWVersion;            ///< Hardware version
   UBYTE                  HWRevision;           ///< Hardwrae revision
   UBYTE                  BT_FWVersion;         ///< Firmware version of the bluetooth module
   UBYTE                  BT_FWRevision;        ///< Firmware revision of the bluetooth module
   UBYTE                  OSType;               ///< Type of the used os (MQX, FreeRTOS,...)
   UBYTE                  OSVersion;            ///< Version of the used os
   UBYTE                  OSRevision;           ///< Revision of the used os
   UBYTE                  OSSubRevision;        ///< Subrevision of the used os
   UWORD                  NumOfFiles;           ///< Actual number of measurement files
} MSG_DATA_DEVICE_INFO;

/// Defintion of the data structure of the message MSG_DEVICE_CONFIG
typedef struct tagMSG_DATA_DEVICE_CONFIG
{
   UWORD                  MeasurePeriodNormal;  ///< Measure period in ms for the normal mode
   UWORD                  MeasurePeriodLogging; ///< Measure period in ms for the logging mode
} MSG_DATA_DEVICE_CONFIG;

/// Defintion of the data structure of the message MSG_ACTUAL_MVALUES
typedef struct tagMSG_DATA_ACTUAL_MVALUES
{
   unsigned int           TimestampHi;          ///< Hi-nibble of the timestamp of the last measurement
   unsigned int           TimestampLo;          ///< Lo-nibble of the timestamp of the last measurement
   float                  ActualAltitude;       ///< Altitude in meters
   float                  ActualPressure;       ///< Pressure in pascal
   float                  ActualTemperature;    ///< Temperature in degree celcius
   float                  ActualAccXDir;        ///< Acceleration in X dir in g
   float                  ActualAccYDir;        ///< Acceleration in Y dir in g
   float                  ActualAccZDir;        ///< Acceleration in Z dir in g
   float                  MinimalAltitude;      ///< Minimal altitude in meters
   float                  MinimalPressure;      ///< Minimal pressure in pascal
   float                  MinimalTemperature;   ///< Minimal temperature in degree celcius
   float                  MinimalAccXDir;       ///< Minimal acceleration in X dir in g
   float                  MinimalAccYDir;       ///< Minimal acceleration in Y dir in g
   float                  MinimalAccZDir;       ///< Minimal acceleration in Z dir in g
   float                  MaximalAltitude;      ///< Maximal altitude in meters
   float                  MaximalPressure;      ///< Maximal pressure in pascal
   float                  MaximalTemperature;   ///< Maximal temperature in degree celcius
   float                  MaximalAccXDir;       ///< Maximal acceleration in X dir in g
   float                  MaximalAccYDir;       ///< Maximal acceleration in Y dir in g
   float                  MaximalAccZDir;       ///< Maximal acceleration in Z dir in g
} MSG_DATA_ACTUAL_MVALUES;

/// Defintion of the data structure of the message MSG_SET_LED_JOB_DATA
typedef struct tagMSG_DATA_SET_LED_JOB
{
   LED_NAME               LEDName;              ///< Name of the led
   LED_STATE              LEDJob;               ///< Job for the led
   UWORD                  NumOfFlashes;         ///< Number of flashes for a flash job
   UBYTE                  FlashFrequency;       ///< Flash frequency for flash job
} MSG_DATA_SET_LED_JOB;

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------

#endif //__MESSAGEDEFS_H
