//-----------------------------------------------------------------------------
//  MeasureM.h
/// @file
///
/// @brief Header for the modul MeasureM.c
///
/// This is the header for the modul MeasureM.c.
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-02-10 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __MEASUREM_H
 #define __MEASUREM_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------
/// Definition of the enum for the jobs for the measure task
typedef enum tagMEASURE_M_JOB
{
   MMJ_NO_JOB = 0,                        ///< No job
   MMJ_INIT_MEASURE_SYSTEM,               ///< Init the measuring system
   MMJ_DO_MEASURING,                      ///< Doing a measurement
   MMJ_CONFIG_CHANGED,                    ///< The device configuration is changed 
   MMJ_MEASURE_MODE_CHANGED               ///< The measure mode is changed
} MEASURE_M_JOB;

/// Defintion for the enum to identifier the elments in the min- / max-values structure
typedef enum tagVALUE
{
   VAL_ACTUAL_ALTITUDE = 0,               ///< Actual altitude
   VAL_ACTUAL_PRESSURE,                   ///< Actual pressure
   VAL_ACTUAL_TEMPERATURE,                ///< Actual temperature
   VAL_ACTUAL_ACC_X_POS,                  ///< Actual acceleration x direction
   VAL_ACTUAL_ACC_Y_POS,                  ///< Actual acceleration y direction
   VAL_ACTUAL_ACC_Z_POS,                  ///< Actual acceleration z direction
   VAL_MINIMAL_ALTITUDE,                  ///< Minimal altitude
   VAL_MINIMAL_PRESSURE,                  ///< Minimal pressure
   VAL_MINIMAL_TEMPERATURE,               ///< Minimal temperature
   VAL_MINIMAL_ACC_X_POS,                 ///< Minimal acceleration x direction
   VAL_MINIMAL_ACC_Y_POS,                 ///< Minimal acceleration y direction
   VAL_MINIMAL_ACC_Z_POS,                 ///< Minimal acceleration z direction
   VAL_MAXIMAL_ALTITUDE,                  ///< Maximal altitude
   VAL_MAXIMAL_PRESSURE,                  ///< Maximal pressure
   VAL_MAXIMAL_TEMPERATURE,               ///< Maximal temperature
   VAL_MAXIMAL_ACC_X_POS,                 ///< Maximal acceleration x direction
   VAL_MAXIMAL_ACC_Y_POS,                 ///< Maximal acceleration y direction
   VAL_MAXIMAL_ACC_Z_POS,                 ///< Maximal acceleration z direction
   VAL_TIMESTAMP_LO,
   VAL_TIMESTAMP_HI
} VALUE;

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------
// Taskfunction of the measuring task
void MeasureM_TaskFunction (void * pvParameters);
// Set a new job for the measuring task
void MeasureM_SetJob (MEASURE_M_JOB MeasureMJob);
// Gets a value from the min-/max-value structure
float MeasureM_GetMeasureValue (VALUE enValue);
// Resets the min- and max-values
void MeasureM_ClearMeasureValues (void);
// Gets the timestamp of the last measuring
int MeasureM_GetTimestamp (VALUE enValue);
// Increment the Hi value of the timestamp
void MeasureM_IncrementTimestampHi();

#endif //__MEASUREM_H
