//-----------------------------------------------------------------------------
//  FlashMemM.h
/// @file FlashMemM.h
///
/// @brief Header for the module FlashMemM.c
///
/// This is the header for the module FlashMemM.c.
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-04-23 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __FLASHMEMM_H
 #define __FLASHMEMM_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------

/// Definition for the flash size enum
typedef enum tagFLASH_SIZE
{
   FLASH_SIZE_NO_INFO = 0,                ///< no info about the flash size
   FLASH_SIZE_2MBIT,                      ///< flash size 2 mbit
   FLASH_SIZE_4MBIT,                      ///< flash size 4 mbit
   FLASH_SIZE_8MBIT                       ///< flash size 8 mbit
} FLASH_SIZE;

/// Definition for the manufacturer enum
typedef enum tagFLASH_MANFCT
{
   FLASH_MANFCT_NO_INFO = 0,              ///< no info about the manufacturer
   FLASH_MANFCT_MICROCHIP                 ///< manufacturer microchip
} FLASH_MANFCT;

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------

// Taskfunction of the FlashMemM-task
void FlashMemM_TaskFunction (void * pvParameters);

#endif //__FLASHMEMM_H
