//-----------------------------------------------------------------------------
//  SST25PFx_Defs.h
/// @file
///
/// @brief Definitions for the registers of the flash memory SST25PFx / SST25VFx
///
/// This header contains all definitions for the registers of the flash memory
/// SST25PFx / SST25VFx.
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-04-23 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __SST25PFX_DEFS_H
 #define __SST25PFX_DEFS_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------
/// Verwendeter Flashbaustein
#define FLASH_DEVICE_SST25VFX

// Kommando IDs fr die verschiednen Flashkommandos
/// ID Kommando "Statusregister schreiben"
#define SST25PFX_REG_WRSR              0x01
/// ID Kommando "Einzelnes Datenyte programmieren"
#define SST25PFX_REG_BYTE_PROGRAM      0x02
/// ID Kommando "Daten lesen"  
#define SST25PFX_REG_READ              0x03
/// ID Kommando "Schreiben/Lschen sperren"
#define SST25PFX_REG_WRDI              0x04
/// ID Kommando "Statusregister lesen"
#define SST25PFX_REG_RDSR              0x05
/// ID Kommando "Schreiben/Lschen erlaubem"
#define SST25PFX_REG_WREN              0x06
/// ID Kommando "Sektor lschen"
#define SST25PFX_REG_SECTOR_ERASE      0x20
/// ID Kommando "Statusregister 1 lesen"
#define SST25PFX_REG_RDSR1             0x35
/// ID Kommando "Speicherblock (32k) lschen"
#define SST25PFX_REG_32K_BLOCK_ERASE   0x52
/// ID Kommando "Kompletten Flashspeicher lschen"
#define SST25PFX_REG_CHIP_ERASE        0x60
/// ID Kommando "Security ID lesen"
#define SST25PFX_REG_READ_SECURITY_ID  0x88
/// ID Kommando "ID des Flashbausteins auslesen"
#define SST25PFX_REG_RDID              0x90
/// ID Kommando "Daten schreiben mit autoinkrement"
#define SST25PFX_REG_AAI_WORD_PROGRAM  0xAD
/// ID Kommando "Speicherblock (64k) lschen"
#define SST25PFX_REG_64K_BLOCK_ERASE   0xD8

// Bits des Statusregisters
/// Busy-Flag des Flashspeichers
#define SR_BUSY      	               0x01
/// Flag Speicher schreiben erlauben/sperren
#define SR_WEL       	               0x02
/// Flag Blockprotectionbit 0
#define SR_BP0       	               0x04
/// Flag Blockprotectionbit 1
#define SR_BP1       	               0x08
/// Flag Blockprotectionbit 2
#define SR_BP2       	               0x10
/// Flag security id state
#define SR_SEC			                  0x20
/// Flag Auto-Adress-inkrement beim schreiben
#define SR_AAI       	               0x40
/// Flag Blockprotectionbits read-only
#define SR_BPL       	               0x80

// Bits des Statusregisters 1
/// Flag Top Sector Protection status
#define SR_TSP                         0x04
/// Flag Bottom Sector Protection status
#define SR_BSP                         0x08

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------

#endif //__SST25PFX_DEFS_H
