//-----------------------------------------------------------------------------
//  MPL3115A2_Defs.h
/// @file
///
/// @brief Definition for the MPL3115A2 device
///
/// All definitions for the MPL3115A2 device are inside of this header file.
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-02-28 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __MPL3115A2_DEFS_H
 #define __MPL3115A2_DEFS_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------

/// Divider for the calculation of the pressure
#define MPL3115A2_P_DIVIDER         0x04
/// Divider for the calculation of the temperature
#define MPL3115A2_T_DIVIDER         0x10
/// Divider for the calculation of the altitude
#define MPL3115A2_A_DIVIDER         0x10

/// Control Register 4: Enable data ready interrupt
#define SET_INT_EN_DRDY_MASK        0x80
/// Control Register 5: Data ready interrupt is routet to INT1
#define SET_INT_CFG_DRDY_MASK       0x80
/// Pressure/Temparture data cfg register: enable event on new pressure / altitude data
#define SET_PDEFE_MASK              0x02
/// Pressure/Altitude or temperature data ready
#define STATUS_PDR_MASK             0x04
/// I2C address of the device
#define MPL3115A2_SLAVE_ADDRESS     0x60


/// Anzahl der Bytes fuer einen Hoehen- oder Luftdruckmesswert
#define MPL3115A2_P_VALUE_SIZE      0x03
/// Anzahl der Bytes fuer einen Hoehen- oder Luftdruckmesswert plus
/// Temperaturmesswert
#define MPL3115A2_P_T_VALUE_SIZE    0x05

/*----------------------------------------------------------------------------*/
/* Registeradressen                                                           */
/*----------------------------------------------------------------------------*/
/// Sensor Status Register
#define MPL3115A2_REG_STATUS        0x00
/// Pressure Data Out Register (0x01-0x03)
#define MPL3115A2_REG_OUT_P         0x01
/// Temperature Data Out Register (0x04-0x05)
#define MPL3115A2_REG_OUT_T         0x04
/// Sensor Status Register
#define MPL3115A2_REG_DR_STATUS     0x06
/// Pressure Data Out Delta (0x07-0x09)
#define MPL3115A2_REG_OUT_P_DELTA   0x07
/// Temperature Data Out Delta (0x07-0x09)
#define MPL3115A2_REG_OUT_T_DELTA   0x0A
/// Device Identification Register
#define MPL3115A2_REG_WHO_AM_I      0x0C
/// FIFO-Statusregister
#define MPL3115A2_REG_F_STATUS      0x0D
/// FIFO 8-Bit Data Access Register
#define MPL3115A2_REG_F_DATA        0x0E
/// FIFO Setup Register
#define MPL3115A2_REG_F_SETUP       0x0F
/// Register Time since FIFO overflow
#define MPL3115A2_REG_TIME_DLY      0x10
/// System Mode Register
#define MPL3115A2_REG_SYSMODE       0x11
/// Interrupt Source Register
#define MPL3115A2_REG_INT_SOURCE    0x12
/// PT Data Configuration Register
#define MPL3115A2_REG_PT_DATA_CFG   0x13
/// BAR Input in Register (0x14 - 0x15)
#define MPL3115A2_REG_BAR_IN        0x14
/// Pressure Target Register (0x16 - 0x17)
#define MPL3115A2_REG_P_TGT         0x16
/// Temperature Target Register
#define MPL3115A2_REG_T_TGT         0x18
/// Pressure/Altitude Window Register (0x19 - 0x1A)
#define MPL3115A2_REG_P_WND         0x19
/// Temperature Window Register
#define MPL3115A2_REG_T_WND         0x1B
/// Minimum Pressure Data Out Register (01C - 0x1E)
#define MPL3115A2_REG_P_MIN         0x1C
/// Minimum Pressure Data Out Register (01F - 0x20)
#define MPL3115A2_REG_T_MIN         0x1F
/// Maximum Pressure Data Out Register (021 - 0x23)
#define MPL3115A2_REG_P_MAX         0x21
/// Maximum Pressure Data Out Register (024 - 0x25)
#define MPL3115A2_REG_T_MAX         0x24
/// Control Register 1
#define MPL3115A2_REG_CTRL_REG1     0x26
/// Control Register 2
#define MPL3115A2_REG_CTRL_REG2     0x27
/// Control Register 3
#define MPL3115A2_REG_CTRL_REG3     0x28
/// Control Register 4
#define MPL3115A2_REG_CTRL_REG4     0x29
/// Control Register 5
#define MPL3115A2_REG_CTRL_REG5     0x2A
/// Pressure Data User Offset Register
#define MPL3115A2_REG_OFF_P         0x2B
/// Temperature Data User Offset Register
#define MPL3115A2_REG_OFF_T         0x2C
/// Altitude Data User Offset Register
#define MPL3115A2_REG_OFF_H         0x2D

/*----------------------------------------------------------------------------*/
/* Control Register 1                                                         */
/*----------------------------------------------------------------------------*/
/// Standby mask
#define STANDBY_SBYB_MASK           0xFE
/// Active mask
#define ACTIVE_SBYB_MASK            0x01

/// Altimeter mode mask
#define ALTI_ALT_MASK               0x80
/// Barometer mode mask
#define BARO_ALT_MASK               0x7F

/// Set OST-Bit mask
#define SET_OST_MASK                0x02
/// Reset OST-Bit mask
#define RESET_OST_MASK              0xFD

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------

#endif //__MPL3115A2_DEFS_H
