//-----------------------------------------------------------------------------
//  DControlAPI.h
/// @file
///
/// @brief Header for the module DControlAPI.c
///
/// This is the header for the module DControlAPI.c.
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-04-26 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __DCONTROLAPI_H
 #define __DCONTROLAPI_H

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------
#include "Basetyp.h"

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitionen, Makros und Konstanten
//-----------------------------------------------------------------------------
/// Size of the dcontrol api header
#define SIZE_OF_DC_API_HEADER              10

// Command ids for dcontrol commands
/// DControl API command id for cmd ACK
#define CMD_ID_ACK                     0x0010
/// DControl API command id for cmd NAK
#define CMD_ID_NAK                     0x0020
/// DControl API command id for cmd PING
#define CMD_ID_PING                    0x0500
/// DControl API command id for cmd PING_ACK
#define CMD_ID_PING_ACK                0x0510
/// DControl API command id for cmd REQ_CONNECT
#define CMD_ID_REQ_CONNECT             0x0530
/// DControl API command id for cmd CONNECT
#define CMD_ID_CONNECT                 0x0540

/// DControl API command id for cmd REQ_DEVICE_INFO
#define CMD_ID_REQ_DEVICE_INFO         0x1000
/// DControl API command id for cmd DEVICE_INFO
#define CMD_ID_DEVICE_INFO             0x1010
/// DControl API command id for cmd REQ_ACTUAL_VALUES
#define CMD_ID_REQ_ACTUAL_MVALUES      0x1020
/// DControl API command id for cmd ACTUAL_MVALUES
#define CMD_ID_ACTUAL_MVALUES          0x1030
/// DControl API command id for cmd REQ_DEVICE_CONFIG
#define CMD_ID_REQ_DEVICE_CONFIG       0x1040
/// DControl API command id for cmd DEVICE_INFO
#define CMD_ID_DEVICE_CONFIG           0x1050
/// DControl API command id for cmd RESET_MVALUES
#define CMD_ID_RESET_MVALUES           0x1060
/// DControl API command id for cmd MEASURE_MODE
#define CMD_ID_MEASURE_MODE            0x1070
/// DControl API command id for cmd REQ_MEASURE_MODE
#define CMD_ID_REQ_MEASURE_MODE        0x1080
/// DControl API command id for cmd CLEAR_ALL_DATA_FILES
#define CMD_ID_CLEAR_ALL_DATA_FILES    0x1090
/// DControl API command id for cmd REQ_FFS_FILE
#define CMD_ID_REQ_FFS_FILE            0x1100
/// DControl API command id for cmd FFS_FILE
#define CMD_ID_FFS_FILE                0x1110
/// DControl API command id for cmd FFS_FILE_HEADER
#define CMD_ID_FFS_FILE_HEADER         0x1120
/// DControl API command id for cmd FFS_FILE_COMPLETE
#define CMD_ID_FFS_FILE_COMPLETE       0x1130

// Return values for the module functions
/// Return code: ok
#define DC_API_OK                        0x01
/// Return code: identifier is unknown
#define DC_API_UNKNOWN_IDENTIFIER        0x02
/// Return code: crc value is incorrect
#define DC_API_CRC_VALUE_FALSE           0x03 

/// Defintion of the command header
typedef struct tagCMD_HEADER
{
   UBYTE    Identifier;                   ///< Identifier '#'
   UWORD    CommandID;                    ///< Command id
   UWORD    ActPacketNumber;              ///< Actual packet number
   UWORD    TotalPacketNumber;            ///< Total number of packets
   UWORD    SizeOfPacket;                 ///< Number of parameters in the packet
   UBYTE    CRC;                          ///< CRC
} CMD_HEADER;

//-----------------------------------------------------------------------------
// Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der public-Functionen
//-----------------------------------------------------------------------------

UBYTE BaroALtiAPI_GetCmdHeader( PUBYTE pMsgRawData, CMD_HEADER * pCmdHeader );

UBYTE BaroAltiAPI_SetMsgAck (PUBYTE pMsgRawData);

UBYTE BaroAltiAPI_SetMsgNak (PUBYTE pMsgRawData);

UBYTE BaroAltiAPI_SetMsgPingAck (PUBYTE pMsgRawData);

UBYTE BaroAltiAPI_SetMsgConnect (PUBYTE pMsgRawData, UBYTE DeviceType, UBYTE ConEncryption, UWORD MaxNumOfParams);

UBYTE BaroAltiAPI_SetMsgDeviceInfo(PUBYTE pMsgRawData, MSG_DATA_DEVICE_INFO * pDeviceInfo);

UBYTE BaroAltiAPI_SetMsgDeviceConfig (PUBYTE pMsgRawData, MSG_DATA_DEVICE_CONFIG * pDeviceConfig);

UBYTE BaroAltiAPI_SetMsgActualMValues (PUBYTE pMsgRawData, MSG_DATA_ACTUAL_MVALUES * pActualMValues);

UBYTE BaroAltiAPI_GetMsgDeviceConfigData (PUBYTE pMsgRawData, MSG_DATA_DEVICE_CONFIG * pDeviceConfig);

UBYTE BaroAltiAPI_GetMsgMeasureModeData (PUBYTE pMsgRawData, MSG_DATA_MEASURE_MODE * pMeasureMode);

UBYTE BaroAltiAPI_SetMsgMeasureMode (PUBYTE pMsgRawData, MSG_DATA_MEASURE_MODE * pMeasureMode);

UBYTE BaroAltiAPI_GetMsgReqMeasureFileData (PUBYTE pMsgRawData, MSG_DATA_REQ_MEASURE_FILE * pMeasureMode);

UWORD BaroAltiAPI_SetFileBlock (PUBYTE pMsgRawData, PUBYTE pMeasureFileBlock, UWORD SizeOfDataBlock, UWORD iCurFileBlock, UWORD TotalNumOfBlocks );

UBYTE BaroAltiAPI_SetFileHeader (PUBYTE pMsgRawData, UDWORD NumOfData);

UBYTE BaroAltiAPI_SetFFSFileComplete (PUBYTE pMsgRawData );

#endif //__DCONTROLAPI_H
