//-----------------------------------------------------------------------------
//  Basetyp.h
/// @file
///
/// @brief Header for basic data types of the application
///
/// This is the header for basic data types of the application.
///
/// @copyright 2013 TABO - Embedded Systems GmbH & Co.KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-07-16 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------
#ifndef __BASETYP_H
 #define __BASETYP_H

//-----------------------------------------------------------------------------
// Standard include files
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Project specific include files
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitions ,makros and constants
//-----------------------------------------------------------------------------
#ifndef TRUE
   /// Definition for boolean value TRUE
   #define TRUE   1
#endif

#ifndef FALSE
   /// Definition for boolean value FALSE
   #define FALSE  0
#endif

#ifndef _UBYTE_
   #define _UBYTE_                                ///< UBYTE hier definiert
   typedef       unsigned   char           UBYTE; ///< unsigned char 8Bit Wert
   typedef        volatile UBYTE          VUBYTE; ///< volatile unsigned char 8Bit Wert
 
   typedef       unsigned   char      *   PUBYTE; ///< Zeiger auf einen unsigned char 8Bit Wert
   
   typedef       unsigned   char      ** PPUBYTE; ///< Zeiger auf Zeiger auf einen unsigned char 8Bit Wert
   typedef const unsigned   char      *  PCUBYTE; ///< Zeiger auf einen konstanten unsigned char 8Bit Wert
#endif

#ifndef _SBYTE_
   #define _SBYTE_                                ///< SBYTE hier definiert
   typedef         signed   char           SBYTE; ///< signed char 8Bit Wert
   typedef        volatile SBYTE          VSBYTE; ///< volatile signed char 8Bit Wert

   typedef         signed   char      *   PSBYTE; ///< Zeiger auf einen signed char 8Bit Wert
   typedef const   signed   char      *  PCSBYTE; ///< Zeiger auf einen konstanten signed char 8Bit Wert
#endif

#ifndef _UWORD_
   #define _UWORD_                                ///< UWORD hier definiert
   typedef       unsigned  short           UWORD; ///< unsigned short 16Bit Wert
   typedef        volatile UWORD          VUWORD; ///< volatile unsigned short 16Bit Wert

   typedef       unsigned  short      *   PUWORD; ///< Zeiger auf einen unsigned short 16Bit Wert
   typedef const unsigned  short      *  PCUWORD; ///< Zeiger auf einen konstanten unsigned short 16Bit Wert
#endif

#ifndef _SWORD_
   #define _SWORD_                                ///< SWORD hier definiert
   typedef         signed  short           SWORD; ///< signed long 32Bit Wert
   typedef        volatile SWORD          VSWORD; ///< volatile signed long 32Bit Wert

   typedef         signed  short      *   PSWORD; ///< Zeiger auf einen signed long 32Bit Wert
   typedef const   signed  short      *  PCSWORD; ///< Zeiger auf einen signed long 32Bit Wert
#endif

#ifndef _UDWORD_
   #define _UDWORD_                               ///< UDWORD hier definiert
   typedef       unsigned   long           UDWORD;///< unsigned long 32Bit Wert
   typedef       volatile  UDWORD         VUDWORD;///< volatile unsigned long 32Bit Wert

   typedef       unsigned   long      *   PUDWORD;///< Zeiger auf einen unsigned long 32Bit Wert
   typedef const unsigned   long      *  PCUDWORD;///< Zeiger auf einen unsigned long 32Bit Wert
#endif

#ifndef _SDWORD_
   #define _SDWORD_                               ///< SDWORD hier definiert
   typedef         signed   long           SDWORD;///< signed long 32Bit Wert
   typedef       volatile  SDWORD         VSDWORD;///< volatile signed long 32Bit Wert

   typedef         signed   long      *   PSDWORD;///< Zeiger auf einen signed long 32Bit Wert
   typedef const   signed   long      *  PCSDWORD;///< Zeiger auf einen konstanten signed long 32Bit Wert
#endif

#ifndef _REAL_
   #define _REAL_                                 ///< REAL hier definiert
   typedef                 float           REAL;  ///< einfach genauer Real-Wert
   typedef                 float      *   PREAL;  ///< Zeiger auf einen einfach genauen Real-Wert
   typedef const           float      *  PCREAL;  ///< Zeiger auf einen konstamten einfach genauen Real-Wert
#endif

#ifndef _DREAL_                                   
   #define _DREAL_                                 ///< DREAL hier definiert
   typedef                double           DREAL;  ///< doppelt genauer Real-Wert
   typedef                double      *   PDREAL;  ///< Zeiger auf einen doppelt genauen Real-Wert
   typedef const          double      *  PCDREAL;  ///< Zeiger auf einen konstamten doppelt genauen Real-Wert
#endif

#ifndef _OS_WINDOWS
   #ifdef C167
      #ifndef _PUFBYTE_
         #define _PUFBYTE_
         typedef unsigned char far * PUFBYTE;
      #endif

      #ifndef _PUFWORD_
         #define _PUFWORD_
         typedef unsigned short far * PUFWORD;
      #endif
   #endif
#else
   #ifndef _PUFBYTE_
      #define _PUFBYTE_
      typedef unsigned char  * PUFBYTE;
   #endif

   #ifndef _PUFWORD_
      #define _PUFWORD_
      typedef unsigned short  * PUFWORD;
   #endif
#endif

#ifdef __cplusplus
extern "C"
{
#endif

extern const UBYTE  UBMAX;    ///< Grter Wert fr vorzeichenlose 8-Bit-Werte
extern const SBYTE  SBMAX;    ///< Grter Wert fr vorzeichenbehaftete 8-Bit-Werte
extern const UWORD  UWMAX;    ///< Grter Wert fr vorzeichenlose 16-Bit-Werte
extern const SWORD  SWMAX;    ///< Grter Wert fr vorzeichenbehaftete 16-Bit-Werte
extern const UDWORD UDWMAX;   ///< Grter Wert fr vorzeichenlose 32-Bit-Werte
extern const SDWORD SDWMAX;   ///< Grter Wert fr vorzeichenbehaftete 32-Bit-Werte
extern const REAL   RMAX;     ///< Grter Wert fr einfache Gleitkomma-Werte
extern const REAL   RMIN;     ///< Kleinster Wert fr einfache Gleitkomma-Werte
extern const DREAL  DRMAX;    ///< Grter Wert fr doppelt genaue Gleitkomma-Werte
extern const DREAL  DRMIN;    ///< Kleinster Wert fr doppelt genaue Gleitkomma-Werte

#ifdef __cplusplus
}
#endif

#endif //__BASETYP_H
