//-----------------------------------------------------------------------------
//  Application.c
/// @file Application.c
///
/// @brief Startmodule of the application
///
/// This is the startmodule of the application. The idle loop, the creation of
/// all tasks and the init message to the process manager are the main functions
/// of this module.
///
/// @copyright 2012-2013 TABO - Embedded Systems GmbH & Co. KG - All Rights Reserved
///
/// @status  Draft
/// @date    $Date:$
/// @version $Revision:$
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-01-15 Eike Mueller(TABO)
///            Draft => V.1.0
/// @endhistory
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Standard-Include-Dateien
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Eigene Include-Dateien
//-----------------------------------------------------------------------------
#include "Application.h"

#include "OS.h"
#include "GPIO1.h"
#include "MessageDefs.h"

//-----------------------------------------------------------------------------
// Private-Definitionen, -Makros und -Konstanten
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Private-Datentypen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Externe Referenzen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Modulglobale Variable
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Prototypen der private-Functionen
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Implementierung
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//  Function  StartApplication
///
/// @brief Starts the application
///
/// This function starts the application. At first all task of the application
/// will be created. After the taskcreation the init message is sended to the
/// process manager task.
///
/// @status  Draft
/// @date    2013-01-15
/// @author  Eike Mueller(TABO)
///
/// @history
/// Date/Ver   Author/Modification
///
/// 2013-01-15 Eike Mueller(TABO)
///            Draft
/// @endhistory
//-----------------------------------------------------------------------------
void StartApplication( void )
{
   MESSAGE Message;

   // create all tasks of the system
   OS_CreateAllTasks();
   
   // Systeminitialisierung anstossen
   Message.MessageID    = MSG_INIT_SYSTEM;
   Message.pMessageData = NULL;

   if (OS_SendMessage (TASK_ID_PROCESS_M, &Message, WAIT_MAX) == ERR_OS_QUEUE_FULL)
   {
      ///< @todo: EM evtl. Fehlerhanding
   }
}
