#include "System.h"
#include "RCC.h"
#include "LED.h"
#include "Button.h"

void Delay(uint32_t time);

int main() {
  InitializeSystem();
  InitializeLEDs();
  InitializeUserButton();
  SysTick_Config(HCLKFrequency() / 100);

  for (;;) {
    while (!UserButtonState())
      SetLEDs(ALL);
    while (UserButtonState());
    Delay(30);

    while (!UserButtonState())
      SetLEDs(OFF);
    while (UserButtonState());
    Delay(30);
  }
}

volatile uint32_t SysTickCounter = 0;

void Delay(uint32_t time) {
  uint32_t end = SysTickCounter + time;
  while (SysTickCounter != end);
}

void SysTick_Handler() {  
  SysTickCounter++;
}

