#ifndef __LED_H__
#define __LED_H__

#include "stm32f4xx.h"

enum Led {
  OFF    = 0x00, GREEN = 0x01,
  ORANGE = 0x02, RED   = 0x04,
  BLUE   = 0x08, ALL   = 0x0f
};

void InitializeLEDs();

static inline void SetLEDs(int leds) {
  uint16_t val = GPIOD->ODR;
  val &= ~(0x0f << 12);
  val |= leds << 12;
  GPIOD->ODR = val;
}

#endif

