require 'brainlink'

class RoboRover
  signals = {
    :forward => [
      99, 13, 28,  1, 141, 1, 162, 1, 155, 1, 160, 1, 156, 1, 174, 1,
      145, 1, 185, 1, 142, 1, 162, 1, 155, 1, 149, 1, 169, 1, 162, 1,
      156, 1, 174, 1, 155, 1, 162, 1, 155, 1, 149, 1, 169, 1, 161, 6,
      127, 1, 161, 1, 156, 1, 173, 1, 155, 1, 174, 1, 142, 1, 149, 1,
      168, 1, 161, 1, 156, 1, 174, 1, 155, 1, 174, 6, 114, 1, 175, 1,
      143, 1, 149, 1, 168, 1, 161, 1, 156, 1, 186, 1, 143, 1, 162, 6,
      127, 1, 174
    ],
    :backward => [
      99, 13, 23,  1, 146, 1, 173, 1, 155, 1, 162, 1, 156, 1, 149, 1,
      168, 1, 161, 1, 157, 1, 174, 1, 155, 1, 162, 1, 156, 1, 162, 1,
      156, 1, 149, 1, 168, 1, 161, 1, 167, 1, 161, 1, 156, 1, 162, 6,
      128, 1, 162, 1, 156, 1, 149, 1, 169, 1, 161, 1, 156, 1, 173, 1,
      155, 1, 161, 1, 155, 1, 149, 1, 169, 1, 161, 6, 128, 1, 161, 1,
      168, 1, 162, 1, 156, 1, 162, 6, 128, 1, 161, 6, 128, 1, 148, 6,
      140, 1, 161
    ],
    :left => [
      99, 13, 13,  1, 156, 1, 187, 1, 142, 1, 173, 1, 143, 1, 162, 1,
      154, 1, 160, 1, 157, 1, 187, 1, 143, 1, 162, 1, 154, 1, 162, 1,
      155, 1, 148, 1, 168, 1, 162, 1, 156, 1, 186, 1, 143, 1, 175, 6,
      114, 1, 174, 1, 142, 1, 149, 1, 168, 1, 162, 1, 156, 1, 174, 1,
      155, 1, 172, 1, 144, 1, 148, 1, 167, 1, 161, 6, 127, 1, 161, 1,
      168, 1, 161, 6, 126, 1, 161, 6, 127, 1, 174, 1, 144, 1, 162, 6,
      127, 1, 174
    ],
    :right => [
      99, 13, 38,  1, 141, 1, 162, 1, 155, 1, 175, 1, 142, 1, 160, 1,
      157, 1, 174, 1, 145, 1, 185, 1, 142, 1, 163, 1, 155, 1, 149, 1,
      168, 1, 161, 1, 156, 1, 186, 1, 142, 1, 162, 1, 155, 1, 149, 6,
      140, 1, 148, 1, 168, 1, 162, 1, 157, 1, 186, 1, 142, 1, 162, 1,
      155, 1, 148, 1, 168, 1, 161, 1, 156, 1, 174, 6, 115, 1, 174, 1,
      155, 1, 162, 6, 127, 1, 174, 6, 114, 1, 162, 6, 127, 1, 148, 1,
      168, 1, 149
    ],
    :stop => [
      99, 13, 29,  1, 142, 1, 149, 1, 167, 1, 161, 1, 156, 1, 174, 1,
      155, 1, 173, 1, 143, 1, 172, 1, 144, 1, 160, 1, 156, 1, 173, 1,
      144, 1, 173, 1, 155, 1, 175, 1, 143, 1, 149, 1, 169, 1, 162, 6,
      128, 1, 187, 1, 132, 1, 185, 1, 144, 1, 174, 1, 144, 1, 149, 6, 
      140, 1, 160, 1, 157, 1, 186, 1, 131, 1, 173, 6, 126, 1, 162, 6, 
      127, 1, 162, 1, 155, 1, 149, 1, 168, 1, 161, 6, 127, 1, 161, 1,
      157, 1, 172
    ],
    :light => [
      99, 13, 28,  1, 142, 1, 160, 1, 157, 1, 173, 1, 156, 1, 174, 1,
      142, 1, 162, 1, 155, 1, 148, 1, 168, 1, 171, 1, 147, 1, 186, 1,
      142, 1, 174, 1, 142, 1, 149, 1, 169, 1, 161, 1, 157, 1, 173, 6,
      115, 1, 174, 1, 155, 1, 161, 1, 155, 1, 148, 1, 168, 1, 161, 1,
      157, 1, 187, 1, 143, 1, 162, 1, 155, 1, 173, 6, 115, 1, 149, 6,
      140, 1, 148, 1, 169, 1, 161, 1, 157, 1, 184, 1, 144, 1, 174, 1,
      142, 1, 162
    ],
    :demo => [
      99, 13, 13,  1, 169, 1, 163, 1, 158, 1, 176, 1, 156, 1, 176, 1,
      144, 1, 176, 1, 142, 1, 162, 1, 158, 1, 175, 1, 157, 1, 177, 1,
      143, 1, 177, 1, 143, 1, 151, 1, 169, 1, 163, 1, 157, 1, 188, 6,
      118, 1, 176, 1, 142, 1, 176, 1, 143, 1, 150, 1, 169, 1, 163, 6,
      132, 1, 175, 1, 145, 1, 187, 1, 142, 1, 176, 6, 118, 1, 174, 6,
      120, 1, 150, 1, 169, 1, 162, 1, 157, 1, 188, 1, 142, 1, 177, 6,
      118, 1, 163
    ],
    :explore => [
      99, 13, 25,  1, 155, 1, 164, 1, 156, 1, 151, 1, 169, 1, 162, 1,
      157, 1, 176, 1, 155, 1, 163, 1, 156, 1, 164, 1, 156, 1, 163, 1,
      158, 1, 176, 1, 146, 1, 175, 1, 156, 1, 164, 1, 156, 1, 151, 6,
      145, 1, 162, 1, 158, 1, 175, 1, 156, 1, 164, 1, 156, 1, 164, 6,
      132, 1, 164, 1, 156, 1, 163, 1, 158, 1, 175, 6, 121, 1, 175, 6,
      120, 1, 175, 6, 132, 1, 163, 1, 156, 1, 163, 1, 156, 1, 151, 1,
      169, 1, 161
    ],
    :game => [
      99, 13, 33,  1, 154, 1, 163, 1, 155, 1, 150, 1, 168, 1, 162, 1,
      156, 1, 175, 1, 155, 1, 163, 1, 156, 1, 164, 1, 156, 1, 162, 1,
      158, 1, 175, 1, 156, 1, 163, 1, 155, 1, 163, 1, 155, 1, 151, 6,
      144, 1, 161, 1, 157, 1, 175, 1, 157, 1, 163, 1, 156, 1, 163, 1,
      156, 1, 150, 1, 169, 1, 163, 1, 157, 1, 175, 6, 130, 1, 163, 6,
      130, 1, 163, 1, 156, 1, 164, 6, 131, 1, 150, 1, 169, 1, 162, 6,
      132, 1, 160
    ],
    :lookout => [
      99, 13, 25,  1, 155, 1, 163, 1, 155, 1, 150, 1, 168, 1, 162, 1,
      157, 1, 176, 1, 156, 1, 164, 1, 156, 1, 164, 1, 156, 1, 162, 1,
      157, 1, 175, 1, 156, 1, 163, 1, 155, 1, 163, 1, 155, 1, 150, 6,
      144, 1, 162, 1, 157, 1, 175, 1, 146, 1, 174, 1, 155, 1, 163, 6,
      130, 1, 163, 1, 156, 1, 162, 1, 157, 1, 174, 6, 120, 1, 175, 6,
      119, 1, 175, 1, 155, 1, 163, 6, 130, 1, 163, 6, 131, 1, 163, 6,
      131, 1, 164
    ],
    :seek => [
      99, 13, 35,  1, 156, 1, 164, 1, 156, 1, 164, 1, 156, 1, 150, 1, 
      169, 1, 163, 1, 157, 1, 174, 1, 155, 1, 163, 1, 155, 1, 150, 1,
      169, 1, 163, 1, 157, 1, 175, 1, 156, 1, 163, 1, 156, 1, 163, 6,
      130, 1, 149, 1, 169, 1, 163, 1, 157, 1, 175, 1, 155, 1, 163, 6,
      131, 1, 163, 1, 155, 1, 150, 1, 169, 1, 162, 6, 131, 1, 163, 1,
      157, 1, 175, 6, 131, 1, 163, 6, 131, 1, 163, 6, 130, 1, 163, 6,
      131, 1, 164
    ]
  }

  signals.each do |name, ir_signal|
    define_method name, ->(repeat_time = 0) do
      @brainlink.send_raw_ir_signals(ir_signal, repeat_time)
    end
  end

  def initialize(serial_port)
    @brainlink = Brainlink.new(serial_port)
    @brainlink.connect
  end
end

