require 'brainlink'
class RoboRover
  commands = {
    :forward => [0, 17, -95], :backward => [0, 17, -89],
    :left => [0, 17, -83],    :right => [0, 17, -82],
    :stop => [0, 16, -78],    :lights => [0, 17, -80],
    :demo => [0, 16, -79],    :explore => [0, 16, -72],
    :game => [0, 17, -75],    :lookout => [0, 16, -73],
    :seek => [0, 16, -81]
  }

  commands.each do |name, ir_command|
    define_method name, ->(repeat_time = 200) do
      if @disable_object_detection
        @brainlink.send_ir_command(ir_command, 200)
        sleep 0.01
      end
      @brainlink.send_ir_command(ir_command, repeat_time)
    end
  end

  attr_reader :brainlink

  def initialize(serial_port, disable_object_detection = true)
    @disable_object_detection = disable_object_detection
    @brainlink = Brainlink.new(serial_port)
    @brainlink.connect
    @brainlink.init_ir_system(38004, [0x0d3a], 2, 24, 0x0690, 0x019b, 0x01f8)
  end
end

