require 'serialport'

class Brainlink
  def initialize(port, options = {})
    max_retries = options[:max_retries] || 3
    retry_interval = options[:retry_interval] || 0.2
    begin
      @brainlink = SerialPort.new( 
        port,            # port name,
        115200,          # baud rate
        8,               # data bits
        1,               # stop bits
        SerialPort::NONE # parity
      )
    rescue => ex
      if max_retries > 0
        max_retries -= 1
        sleep retry_interval
        retry
      else
        raise "Could not connect to Brainlink: #{ex.message}"
      end
    end
    @brainlink.read_timeout = 300
    @brainlink.read
  end

  def connect
    send_command '*'
  end

  def discovery_mode
    send_command 'Q'
  end

  def light_sensor_value
    (send_command 'L')[0]
  end

  private

  def send_command(command, timeout = 300)
    @brainlink.read_timeout = timeout
    @brainlink.write command
    sleep 0.001
    response = @brainlink.read
    echo = response[0, command.length]
    echo.force_encoding('ASCII-8BIT')
    command.force_encoding('ASCII-8BIT')
    result = response[command.length .. -1]
    if command != '*' and echo.bytes.to_a != command.bytes.to_a
      $stderr.puts "Oops! #{echo} != #{command}"
    end
    !result.nil? ? result.bytes.to_a : []
  end
end

