﻿using System;
using System.IO.Ports;

namespace GpsReader {
    public class GpsReader {
        private SerialPort _arduino;

        public GpsReader(string portName) {
            _arduino = new SerialPort();
            _arduino.PortName = portName;
            _arduino.BaudRate = 9600;
            _arduino.DataBits = 8;
            _arduino.StopBits = StopBits.One;
            _arduino.Parity = Parity.None;
            _arduino.ReadTimeout = 500;
            _arduino.Open();
        }

        public void Run() {
            while (true) {
                try {
                    System.Console.WriteLine(_arduino.ReadLine());
                }
                catch (TimeoutException) { }
            }
        }

        static void Main(string[] args) {
            if (args.Length == 0) {
                System.Console.WriteLine("Bitte seriellen Port angeben.");
            }
            GpsReader gpsReader = new GpsReader(args[0]);
            gpsReader.Run();
        }
    }
}
