const unsigned int BAUD_RATE = 9600;
const unsigned int LED_PIN = 13;

String command = "";
boolean command_available = false;

void setup() { 
  Serial.begin(BAUD_RATE);
  pinMode(LED_PIN, OUTPUT);
} 
 
void loop() {  
  if (command_available) {
    if (command == "on") {
      digitalWrite(LED_PIN, HIGH);
      Serial.println("LED on");
    } else if (command == "off") {
      digitalWrite(LED_PIN, LOW);
      Serial.println("LED off");
    } else {
      Serial.println("Unknown command: " + command);
    }
    command = "";
    command_available = false;
  }
}

void serialEvent() {
  while (Serial.available()) {
    const char c = Serial.read();
    if (c == '\n')
      command_available = true;
    else
      command += c;
  }
}
