#include "SoftwareSerial.h"

const unsigned int POWER_PIN = 4;
const unsigned int BAUD_RATE = 9600;
const unsigned int GPSRATE = 4800;
const unsigned int MAX_LINE = 90;

SoftwareSerial gpsSerial = SoftwareSerial(2, 3); // RX, TX
char buffer[MAX_LINE];

void readLine() {
  int buffidx = 0;
  
  while (true) {
    const char c = gpsSerial.read();
    if (c == -1 || c == '\n')
      continue;
    if ((buffidx == MAX_LINE - 1) || (c == '\r')) {
      buffer[buffidx] = 0;
      return;
    }
    buffer[buffidx++] = c;
  }
}
 
void setup() { 
  Serial.begin(BAUD_RATE);
  gpsSerial.begin(GPSRATE);
  pinMode(POWER_PIN, OUTPUT);
  digitalWrite(POWER_PIN, LOW);
} 
 
void loop() { 
  readLine();
  if (strncmp(buffer, "$GPRMC", 6) == 0)
    Serial.println(buffer);
}
