﻿package com.spheroTest.BallRollen;


import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import orbotix.robot.app.StartupActivity;
import orbotix.robot.base.*;

public class BallRollenActivity extends Activity
{
    private final static int STARTUP_ACTIVITY = 0;

    private Robot mRobot;
    private int rot;
	private int gruen;
	
	//so viele Durchläufe soll der Vorgang haben
	private int i = 20;


    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }

    @Override
    protected void onStart() {
    	super.onStart();

        Intent i = new Intent(this, StartupActivity.class);
        startActivityForResult(i, STARTUP_ACTIVITY);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        
        if(requestCode == STARTUP_ACTIVITY && resultCode == RESULT_OK){

            final String robot_id = data.getStringExtra(StartupActivity.EXTRA_ROBOT_ID);
            if(robot_id != null && !robot_id.equals("")){
                mRobot = RobotProvider.getDefaultProvider().findRobot(robot_id);
                rot = 255;
                gruen = 0;
                //Bewegung und Farbverlauf starten
                rollen(i);
            }
			
        }
    }

    @Override
    protected void onStop() {
        super.onStop();

        mRobot = null;

        RobotProvider.getDefaultProvider().removeAllControls();
    }

    private void rollen(int l){
        
        if(mRobot != null )
			if (i >0){
				rot = rot - 255/i;
				gruen = gruen + 255/i;
                //Neuen Farbwert an Sphero senden
				RGBLEDOutputCommand.sendCommand(mRobot, rot, gruen, 0);
				
				//Kommando zum Rollen übergeben
				RollCommand.sendCommand(mRobot, 0, 20);
				i--;
				//Funktion nach kurzer Zeitspanne wieder aufrufen
				final Handler handler = new Handler();
				handler.postDelayed(new Runnable() {
					public void run() {
						rollen(i);
                } }, 500);
            } else {
				//Kommando zum Stoppen geben
				RollCommand.sendCommand(mRobot, 0, 0);
			}
		}
    }
