///////////////////////////////////////////////////////////////////////////////
///
/// PGPdecoder - decrypts files encrypted by the trojan PGPcoder
///
/// File:    pgpcoder.c
/// Version: 1.1
/// Date:    2005/06/08
/// Author:  Daniel Perez Alvarez
///
///////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define TRUE  1
#define FALSE 0

#define SIG_SIZE  21
#define BUFF_SIZE 4096

const char SIGNATURE[] = "PGPcoder 000000000032";

///////////////////////////////////////////////////////////////////////////////
/// Checks if file is encrypted.
///////////////////////////////////////////////////////////////////////////////
int is_encrypted(char *src_filename)
{
    int encrypted = FALSE;
    FILE *encrypted_file;
    char buffer[SIG_SIZE + 1];

    // open file
    if ((encrypted_file = fopen(src_filename, "rb")) == NULL)
    {
        // couldn't open, exit
        fprintf(stderr, "** Error opening file <%s>\n", src_filename);
        exit(EXIT_FAILURE);
    }

    // see if it starts with the trojan signature
    if (fgets(buffer, SIG_SIZE + 1, encrypted_file) != NULL
        && strcmp(SIGNATURE, buffer) == 0)
    {
        encrypted = TRUE;
    }

    // close file
    fclose(encrypted_file);

    return encrypted;
}

///////////////////////////////////////////////////////////////////////////////
/// Decrypts a file if it's encrypted.
///////////////////////////////////////////////////////////////////////////////
void decrypt(char *src_filename)
{
    FILE *encrypted_file;
    FILE *decrypted_file;
    char *bak_filename;
    char buffer[BUFF_SIZE];

    // check if file is encrypted
    if (is_encrypted(src_filename) == FALSE)
    {
        // it's not, exit
        printf("** File <%s> not encrypted\n", src_filename);
        exit(EXIT_SUCCESS);
    }

    // file is encrypted, proceed
    printf("** File <%s> encrypted, proceeding to decrypt\n", src_filename);

    // rename encrypted file
    bak_filename = (char *)calloc(strlen(src_filename) + 5, sizeof(char));
    sprintf(bak_filename, "%s.bak", src_filename);
    printf("** Copying encrypted file <%s> to <%s>\n", src_filename, bak_filename);
    if (rename(src_filename, bak_filename) != 0)
    {
        fprintf(stderr, "** Error renaming file <%s>\n", src_filename);
        exit(EXIT_FAILURE);
    }

    // open encrypted file
    if ((encrypted_file = fopen(bak_filename, "rb")) == NULL)
    {
        // couldn't open, exit
        fprintf(stderr, "** Error opening file <%s>\n", bak_filename);
        exit(EXIT_FAILURE);
    }
    // create new file
    if ((decrypted_file = fopen(src_filename, "wb")) == NULL)
    {
        // couldn't create, exit
        fprintf(stderr, "** Error creating file <%s>\n", src_filename);
        exit(EXIT_FAILURE);
    }

    // start
    printf("** Decrypting file <%s>\n", src_filename);

    // skip signature
    fseek(encrypted_file, SIG_SIZE, SEEK_SET);
    // do the stuff!
    while (!feof(encrypted_file))
    {
        char x = 0x3A;
        int len;
        int i;

        // read
        len = (int)fread(buffer, 1, BUFF_SIZE, encrypted_file);
        // decrypt bytes read
        for (i = 0; i < BUFF_SIZE; i++)
        {
            buffer[i] = buffer[i] - x;
            x = (x * 0x25) + 0x5C;
        }
        // write
        if ((int)fwrite(buffer, 1, len, decrypted_file) != len)
        {
            // error while writing, exit
            fprintf(stderr, "** Error writing file <%s>\n", src_filename);
            exit(EXIT_FAILURE);
        }
    }

    // close files
    fclose(encrypted_file);
    fclose(decrypted_file);

    // finish
    printf("** Finished decrypting file <%s>\n", src_filename);
}

///////////////////////////////////////////////////////////////////////////////
/// Main function.
///////////////////////////////////////////////////////////////////////////////
int main(int argc, char *argv[])
{
    printf("\n");

    // if not enough parameters, print usage and exit
    if (argc < 2)
    {
        printf("PGPdecoder 1.0\n"
            "--------------\n"
            "Decrypts files encrypted by the trojan PGPcoder.\n"
            "Copyright (C) Daniel Perez Alvarez 2005. All rights reserved.\n\n"
            "Usage: %s <file>\n"
            "  <file>\tfile to decrypt\n",
            argv[0]);
        exit(EXIT_FAILURE);
    }

    // try to decrypt the file specified
    decrypt(argv[1]);

    return EXIT_SUCCESS;
}
