#!/bin/sh
#
# status1.cgi
#
# Verwaltung von Internet-Verbindungen (Ergebnis-Dokument)
# Variante mit Frames, vorbereitet fr bash 2.0
#
# Copyright (C) 1998 Reiner Klaproth, nach Wolfram Pienkoss, Andreas Furbach 
#
C_ON=0
C_OFF=1
NO_PERM=2
IS_LOCKED=3
PROV_FILE=providers

connect_proc ()
{
  local SU_ID=SuSuSu
  local OK_ID=OkOkOk
  local NO_ID=NoNoNo 
  local LCK_ID=LCKLCK
  test -z "${FORM_connection}" && return "${NO_PERM}"
  local RESULT="$(echo "${FORM_password}" | \
      /bin/su -s /bin/bash -l -c "( echo "${SU_ID}" ; \
        { echo "${FORM_password}" | \
     sudo /usr/sbin/online ${FORM_connection} ${FORM_masq} ${otime} > /dev/null ; \
  erg="\$\?" ; }; \ 
      if [ "\$erg" -eq "2" ] ; then echo "${NO_ID}" ; \
      elif [ "\$erg" -eq "0" ] ; then echo "${OK_ID}" ; \
      elif [ "\$erg" -eq "3" ] ; then echo "${LCK_ID}" ; \
      fi )" ${FORM_username} )" 
  test -n "$(echo "${RESULT}" | grep "${LCK_ID}")" && return "${IS_LOCKED}"
  test -n "$(echo "${RESULT}" | grep "${OK_ID}")" && return "${C_ON}"
  test -n "$(echo "${RESULT}" | grep "${NO_ID}")" && return "${NO_PERM}"
  test -n "$(echo "${RESULT}" | grep "${SU_ID}")" && return "${C_OFF}"
  return "${NO_PERM}"
}


read QUERY_STRING
export QUERY_STRING
eval `cgiparse -form`

if [ "${FORM_connection}" = "on" ]; then
  FORM_connection=$(awk -v prv="${FORM_provider}" '$2 ~ prv { print $1 }' ${PROV_FILE})
fi

cgiutils -ct text/html -expires now
cat << xxxxxEOFxxxxx

<HTML>
<HEAD>
   <TITLE>Status der Internet-Verbindung</TITLE>
   <META NAME="Author" CONTENT="Reiner Klaproth, Wolfram Pienkoss, Andreas Furbach">

</HEAD>
<BODY background="whttxtr2.jpg">

<H1 ALIGN=CENTER>Status der Internet-Verbindung</H1>
<P ALIGN=CENTER><FONT SIZE="-1">Momentchen...</FONT></P>
<HR>

xxxxxEOFxxxxx

if [ -f /var/lock/online.user -a "${FORM_connection}" = "kill" ]; then
   if ! [ "${FORM_username}" = "`cat /var/lock/online.user`" -o \
		"${FORM_trans}" = "OK" ]; then
	# Ein Fremder will das Interface schlieen!
	echo "<H2 align=center>Sind Sie sicher ?</H2><P align=center>"
	echo "Der Nutzer <B>`cat /var/lock/online.user`</B> hat das Interface"
	echo "ge&ouml;ffnet. Wollen Sie die Internet-Verbindung wirklich"
	echo "schlie&szlig;en ?"
	echo "<TABLE align=center><TR><TD><FORM action=status1.cgi method=POST>"
	echo "<INPUT name=\"username\" type=hidden value=\"${FORM_username}\">"
	echo "<INPUT name=\"password\" type=hidden value=\"${FORM_password}\">"
	echo "<INPUT name=\"connection\" type=hidden value=\"${FORM_connection}\">"
	echo "<INPUT name=\"provider\" type=hidden value=\"${FORM_provider}\">"
	echo "<INPUT name=\"trans\" type=hidden value=\"OK\">"
	echo "<INPUT type=\"submit\" value=\" Ja \"></FORM></TD>"
	echo "<TD><FORM action=admin1.cgi method=GET>"
	echo "<INPUT type=submit value=\"Nein\"></FORM></TD></TR></TABLE>"
	echo "</P></BODY></HTML>"
	exit 0
   fi 
fi
# Provider zugelassen ?

echo "<H2 ALIGN=CENTER>"

if ! [ "${FORM_connection}" = "kill" ] ; then
   # Erster Test: Benutzer fuer diesen Provider zugelassen ?
  if [ -e /var/lib/online/$FORM_provider ]; then
	if ! grep -q "$FORM_username" /var/lib/online/$FORM_provider 
     		then
		echo "<FONT COLOR=\"#ff0000\">$FORM_username f&uuml;r Provider \"$FORM_provider\" nicht zugelassen</FONT></H2>"
		echo "</BODY></HMTL>"
		exit 0
	fi
  fi
fi

# und hier gehts ins Interface
otime=$((FORM_otime))
connect_proc
RESULT="${?}"
if [ "${RESULT}" = "${NO_PERM}" ]; then
  echo '<FONT COLOR="#0000FF">Zugriff abgelehnt</FONT>'
elif [ "${RESULT}" = "${IS_LOCKED}" ]; then 
  echo '<FONT COLOR="#0000FF">Interface-Anforderung in Bearbeitung</FONT>' 
else
  case "${FORM_connection}" in
    check)
      if [ "${RESULT}" = "${C_ON}" ]; then
	echo '<FONT COLOR="#FF0000">Online</FONT>'
      else
	echo '<FONT COLOR="#008000">Offline</FONT>'
      fi
      ;;
    kill)
      echo '<FONT COLOR="#008000">Verbindung beendet</FONT>'
      ;;
    *)
      if [ "${RESULT}" = "${C_ON}" ]; then
	echo '<FONT COLOR="#FF0000">Verbindung zu '${FORM_provider}' hergestellt'
	if [ -f /var/log/ontime.dat ]; then
	    echo "bis "
	    cat /var/log/ontime.dat
	fi
      else
	echo '<FONT COLOR="#008000">Verbindung nicht hergestellt'
      fi
      echo '</FONT>'
      ;;
  esac
fi
echo "</H2>"

./zustand2.cgi

cat << xxxxxEOFxxxxx
<HR>Letzte &Auml;nderung: 06.01.2000, &copy; Wolfram Pienkoss, 
Klaus Werner, Reiner Klaproth
</BODY>
</HTML>
xxxxxEOFxxxxx
