#!/usr/bin/perl -w
#
# zustand.pl
#
# Liefert als include den Zustand der Verbindungen 
#
# Copyright (C) 1998: Klaus Werner (kwerner@ash.ks.he.schule.de)
#
# online=  0 : keine abgehende Verbindung zu einem Provider
#          1 : es besteht eine abgehende Verbindung!
#          2 : ein Interface steht im Standby
# ergaenzte Fassung 06.01.2000
#
# Korrekturen fuer Modem/X.75 von Reiner Klaproth, 18.02.2000
# Anpassung an ADSL: Reiner Klaproth, 17.9.2000
#
$online=0;

sub zustand {
    if ( -e "/var/lock/$_[0]" ) {
        $user=`cat /var/lock/$_[0]`;
        }
    else { $user="" } ;

    print "<TD align=center>";
    print $_[0];
    print":";
    print "</TD> \n" ;
    # Jetzt den Zustand ermitteln:
    # Der Inhalt der Variablen $user zeigt den Provider - oder ist leer.
    
    if ( $user eq "" ) {
	# Das Interface wird nicht benutzt.
        if ( substr($_[0],0,3) eq "tty" )  {
	    $found=`ls /var/run | grep "mgetty-pid.$_[0]" ` ;
    	    if ( $found ne "" ) {
                print "<TD bgcolor=\"#4040FF\">Wartet auf Einwahl" ; }
            else {
		$found=`ls -l /dev/$_[0] | grep "modem" ` ;
		if ( $found ne "" ) {
		    print "<TD bgcolor=\"#00FF00\">OFFLINE" ; }
		  else {
		    print "<TD>nicht benutzt" ; }
		}
	    }
	else { print "<TD bgcolor=\"#00FF00\">OFFLINE" ; }
        }
    else {
	# Das Interface wird benutzt. Testen wir, wozu
        if ( substr($user,0,4) eq "auto" ) { 
            print "<TD bgcolor=\"#4040FF\">Wartet auf Einwahl"
            }
          else {
            chomp($user);
	    $found=`cat providers | grep "$user"` ;
            if ( $found ne "") {
                if ( -e "/var/lock/$user.standby" ) {
			print "<TD bgcolor=\"#FF9900\">STANDBY: ";
                        $online=2; }	
		  else {
			print "<TD bgcolor=\"#FF0000\">ONLINE: ";
                        $online=1;
		}	
		print $user;
          	@nutzer=`cat /var/lock/online.user`;
                print "  Nutzer: " ;
                chomp ($nutzer[0]);
                print $nutzer[0]; }
              else {
                print "<TD bgcolor=\"#FFFF00\">Dial-In: ";
          	print $user;
	    }
        } 
    }
    print "</TD> \n";
};

print "<SCRIPT language=\"JavaScript\">\n";
print "<!-- hidden\n";
print "function do_imon() {\n";
print "        window.open (\"imon.cgi\",\"imon\",\"width=550,height=120,status=no,toolbar=no,menubar=no\");";
print "        }\n";
print "// -->\n";
print "</SCRIPT>\n"; 

print "<div align=center><H3>Zustand der PPP-Verbindungen:</H3> \n";
print "<TABLE width=\"80%\" align=center border=1> \n";
print "<TR><TH colspan=2 width=\"50%\" bgcolor=\"#888888\"><A href=\"javascript:do_imon()\">ISDN (Imon-Fenster &ouml;ffnen)</a></TH>";
print "<TH colspan=2 bgcolor=\"#888888\">Modem</TH></TR>\n";

print "<TR>";
zustand("ippp0");
zustand("ttyS0");
print "</TR><TR>";
zustand("ippp1");
zustand("ttyS1");
print "</TR><TR>";
zustand("ttyI0");
zustand("ttyS2");
print "</TR><TR>";
zustand("ttyI1");
zustand("ttyS3");
print "</TR><TR><TH colspan=4 bgcolor=\"#888888\">PPP (Modem/ADSL) - Verbindungen</TH></TR><TR>\n";
zustand("ppp0");
zustand("ppp1");
print "</TR></TABLE><HR></div>\n";
