<?

include("ckeditor/ckeditor.php");

$STARTPAGE      = "Start";      // Name der STARTPAGE
$PAGEDIRECTORY   = "../pages/"; // Verzeichnispfad Seiteninhalte (mit / am Ende)

$VERSION         = "0.3";       // Version des Mini-CMS

function OpenFile($filename) { 
  global $PAGEDIRECTORY, $text;
  $file = $PAGEDIRECTORY . $filename . ".html";
  if(!file_exists($file))
    return;
  $f = fopen($PAGEDIRECTORY . $filename . ".html", "r");
  if(!$f)
    return;
  while(!feof($f)) {
    $text .= fread($f, 1024);
  }
  fclose($f);
}

function SaveFile($filename, $text) {
  global $PAGEDIRECTORY;
  $date = time();
  $file = sprintf("%s.html:%s", $filename, $date);
  $f = fopen($PAGEDIRECTORY . $file, "w");
  if(!$f)
    return;
  $result = fwrite($f, $text);
  fclose($f);

  $symlink = $PAGEDIRECTORY . $filename . ".html";
  if(file_exists($symlink))
    unlink($symlink);
  symlink($file, $symlink);
  return(0);
}

if(!$p) {
  $pagename = $STARTPAGE;
} else {
  if(preg_match("/[^a-zA-Z0-9_-]/", $p)) {
    $pagename = $STARTPAGE;
  } else {
    $pagename = $p;
  }
}

if($edit) {
  $Title = "Administration: $pagename";

  if(!file_exists($PAGEDIRECTORY . "head.php"))
    include($PAGEDIRECTORY . "head.php");

  OpenFile($pagename);
  print("<script type=\"text/javascript\" src=\"ckeditor/ckeditor.js\"></script>\n<form action=\"$PHP_SELF\" method=\"post\">\n");

  $ckeditor = new CKEditor();
  // Basiskonfiguration
  $ckeditor->basePath = "ckeditor/";
  $ckeditor->config['language'] = "de";
  $ckeditor->config['height'] = 400;
  $ckeditor->config['skin'] = "office2003";
  //$ckeditor->config['skin'] = "kama";
  //$ckeditor->config['skin'] = "v2";

  // Werkzeugleiste
  $ckeditor->config['toolbar'] = array(
    array('Cut','Copy','Paste','PasteText','PasteFromWord','-','Print'),
    array('Undo','Redo','-','Find','Replace','-','SelectAll','RemoveFormat'),
    array('Anchor','Unlink','Link','Image'),
    array('Table','HorizontalRule','PageBreak','Smiley','SpecialChar'),
    array('NumberedList','BulletedList','-','Outdent','Indent','Blockquote','CreateDiv'),
    '/',
    array('Bold','Italic','Underline','Strike','-','Subscript','Superscript'),
    array('Styles','Format','Font','FontSize'),
    array('TextColor','BGColor'),
    array('JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock')
  );

  // KCFinder einbinden
  $ckeditor->config['filebrowserBrowseUrl'] = 'kcfinder/browse.php?type=files';
  $ckeditor->config['filebrowserImageBrowseUrl'] = 'kcfinder/browse.php?type=images';
  $ckeditor->config['filebrowserFlashBrowseUrl'] = 'kcfinder/browse.php?type=flash';
  $ckeditor->config['filebrowserUploadUrl'] = 'kcfinder/upload.php?type=files';
  $ckeditor->config['filebrowserImageUploadUrl'] = 'kcfinder/upload.php?type=images';
  $ckeditor->config['filebrowserFlashUploadUrl'] = 'kcfinder/upload.php?type=flash';

  // Ohne ueres Framework vollstndige HTML-Dateien erstellen
  if(!file_exists($PAGEDIRECTORY . "head.php"))
    $ckeditor->config['fullPage'] = true;

  $ckeditor->editor("TEXT", $text);
  print("<input type=\"hidden\" name=\"p\" value=\"$pagename\">\n<input type=\"submit\" name=\"save\" value=\"Speichern\">\n<input type=\"submit\" name=\"exit\" value=\"Abbrechen\">\n</form>\n");

  if(!file_exists($PAGEDIRECTORY . "tail.php"))
    include($PAGEDIRECTORY . "tail.php");

} elseif($save) {
  if(strlen($TEXT) > 0) {
    SaveFile($pagename, stripslashes($TEXT));
  }
  header(sprintf("Location: %s?p=%s", $PHP_SELF, $pagename));
  exit;

} elseif($neu) {
  $Title = "Administration: Neue Seite anlegen";
  if(!file_exists($PAGEDIRECTORY . "head.php"))
    include($PAGEDIRECTORY . "head.php");
  ?>
    <h3>Neue Seite anlegen</h3>
    <form action="<?=$PHP_SELF?>" method="get">
      Name der Seite: <input type="text" name="p" value="" size="20" maxlength="30">
      <input type="hidden" name="edit" value="1">
      <input type="submit" value="Editieren"> 
    </form>
    <p>Bitte keine Datei-Erweiterung (.html, .txt o..) angeben, sondern nur den Namen der Seite.<br>
    Erlaubt sind nur die Zeichen A-Z, a-z, 0-9 sowie Minus und Unterstrich.<br>
    <b>Keine Punkte, Doppelpunkte, Schrgstriche, Anfhrungszeichen, Umlaute oder andere Sonderzeichen verwenden!</b></p>
  <?php
  if(!file_exists($PAGEDIRECTORY . "tail.php"))
    include($PAGEDIRECTORY . "tail.php");
} else {
  $Title = "Administration: $pagename";

  if(!file_exists($PAGEDIRECTORY . "head.php"))
    include($PAGEDIRECTORY . "head.php");

  OpenFile($pagename);

  if($text) {
    print("$text");
    printf("<br><div align=\"right\"><small>Letzte nderung: %s</small>&nbsp;|&nbsp;<a href=\"%s?p=%s&edit=1\">Edit</a>&nbsp;|&nbsp;<a href=\"%s?neu=1\">Neu</a></div>\n", strftime("%d.%m.%Y, %H:%M", filemtime($PAGEDIRECTORY . $pagename . ".html")), $PHP_SELF, $pagename, $PHP_SELF);
  }
  else {
    printf("<h3>Sorry, die angeforderte Seite existiert nicht.</h3>\n<a href=\"%s?p=%s&edit=1\">Seite neu anlegen</a>", $PHP_SELF, $pagename);
  }
  if(!file_exists($PAGEDIRECTORY . "tail.php"))
    include($PAGEDIRECTORY . "tail.php");
}
